
-- ***************   DROP DE TABELAS E SEQUENCIAS  ********************

DROP TABLE CONTROLE;
DROP TABLE FXHORARIA;
DROP TABLE FERIADO;
DROP TABLE DAT07;
DROP TABLE DAT08;
DROP TABLE CP_BN;
DROP TABLE CP_NB;
DROP TABLE DAM00;
DROP TABLE DAM01;
DROP TABLE DAM02;
DROP TABLE DAM03;
DROP TABLE DAT09;
DROP TABLE SNBE;
DROP TABLE SBBE;
DROP TABLE TABALARME;
DROP TABLE TABDEV;
DROP TABLE CONTDIG;
DROP TABLE CONTDIG_VERI;
DROP TABLE CONTDIG_OMOK;
DROP TABLE CONTDIG_SAGEM;
DROP TABLE CONTDIG_TSI1;
DROP TABLE MAPABIO;
DROP TABLE SITENTRADA;
DROP TABLE CONTFUNC;
DROP TABLE DATAHORA;
DROP TABLE TABLOCKS;

DROP CLUSTER CONTFXHOR;

DROP TABLE TERMBENEF;
DROP TABLE BENEFICIO;
DROP TABLE LBENEF00;
DROP TABLE LBENEF01;
DROP TABLE LBENEF02;
DROP TABLE LBENEF03;
DROP TABLE LBENEF04;
DROP TABLE LBENEF05;
DROP TABLE LBENEF06;
DROP TABLE LBENEF07;
DROP TABLE LBENEF08;
DROP TABLE LBENEF09;
DROP TABLE LBENEF10;
DROP TABLE LBENEF11;
DROP TABLE LBENEF12;
DROP TABLE LBENEF13;
DROP TABLE LBENEF14;
DROP TABLE LBENEF15;
DROP TABLE LBENEF16;
DROP TABLE LBENEF17;
DROP TABLE LBENEF18;
DROP TABLE LBENEF19;
DROP TABLE LBENEF20;
DROP TABLE LBENEF21;
DROP TABLE LBENEF22;
DROP TABLE LBENEF23;

DROP TABLE INFOMAT;
DROP TABLE BLOQSAD;
DROP TABLE BLOQTIPO;
DROP TABLE EXCESAD;
DROP TABLE EXCETIPO;

DROP TABLE ATUALI;
DROP TABLE LIMPATU;
DROP TABLE CONTVEI;
DROP TABLE PENDSMART;
DROP TABLE EXPIREATU;

DROP TABLE CREDLOG;
DROP TABLE VEICULO;
DROP TABLE COUNT_BY_VEIC;
DROP TABLE SITCOLETOR;

DROP TABLE PEND_ON001;
--DROP TABLE PEND_ON002;
DROP TABLE PEND_ON002ON;
DROP TABLE PEND_ON002OFF;
DROP TABLE PEND_ON002LPZ;

DROP TABLE PEND_ON003;
DROP TABLE PEND_ON004;
--DROP TABLE PEND_ON005;
--DROP TABLE PEND_ON006;
DROP TABLE PEND_ON007;

DROP TABLE PEND_ON008ON;
DROP TABLE PEND_ON008OFF;
DROP TABLE PEND_ON008LPZ;

DROP TABLE LOGPEND;
DROP TABLE TMP_LISTAPENDENCIA;
DROP TABLE TMP_CODINS;
DROP TABLE TMP_LISTALIMPAOFF;
DROP TABLE TMP_LISTAPENDENCIA_OFF;
DROP TABLE PEND_GRUPO;

DROP TABLE MATCODIN;
DROP TABLE CONTPLANTA;
DROP TABLE GEOMOK001;

DROP TABLE TMP_DIG001;
DROP TABLE TMP_DIG003;
DROP TABLE DIG001;
DROP TABLE DIG002;
DROP TABLE DIG003;

DROP TABLE DAT05;

DROP TABLE SISINFO;
DROP TABLE DSPMENS;

DROP TABLE CONTCPF;
DROP TABLE DAM99;
DROP TABLE BDCC_CRACHA;

DROP TABLE DAT10;

DROP SEQUENCE TELESEQ;
DROP SEQUENCE SEQSEMAF;

DROP SEQUENCE SeqInfoConex;
DROP SEQUENCE SeqInfoRep;

-- NAO HA DROP DA TABELA REPPONTO


-- *******************************  CRIACAO DE SEQUENCIAS *******************************

CREATE SEQUENCE TELESEQ START WITH 0000010001 MINVALUE 0000010001 
MAXVALUE 0010000000 CYCLE;

CREATE SEQUENCE SEQSEMAF START WITH 0100000001 MINVALUE 0100000001 
MAXVALUE 0100001000 CYCLE;

CREATE SEQUENCE SeqInfoConex START WITH 1 MINVALUE 1 
MAXVALUE 999999999999 CYCLE;

CREATE SEQUENCE SeqInfoRep START WITH 1 MINVALUE 1 
MAXVALUE 999999999999 CYCLE;

-- ********************************* CRIACAO DE CLUSTER E TABELAS  ****************************

CREATE CLUSTER CONTFXHOR (
	ICARD CHAR(12))
  STORAGE (INITIAL 40M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED
           PCTINCREASE 0 );

-- *******************************************************

CREATE TABLE CONTROLE (
  ICARD        CHAR(12) NOT NULL,
  GRUPO        CHAR(3)  default '000' 		NOT NULL, 
  CODIG        CHAR(6)  default '      ',
  TPFIS        CHAR(1)  default ' ',       
  SITUA        CHAR(1)  default '1' 		NOT NULL,
  SUBNV        CHAR(5)  default '00   ',    -- 99 niveis
  PLANTA       CHAR(3)  default '000',
  DATAHORA     CHAR(10) default '3112202359',
  ULTRS        CHAR(25) default '0101902359               ',
  FX_FLG       CHAR(1)  default '0',
  FX_DTA       CHAR(11) default '           ',
  TEMPO_ALM    CHAR(3)  default '   ',
  DATINI       CHAR(6)  default '      ',
  DATFIM       CHAR(6)  default '      ',
  MENSAGEM     CHAR(32) default ' ',
  DTA_MENS     CHAR(6)  default '      ',
  QTD_MENS     CHAR(2)  default '  ',
  CRED_FX1     CHAR(2)  default '00',
  FX_1         CHAR(8)  default '24002400',
  CRED_FX2     CHAR(2)  default '00',
  FX_2         CHAR(8)  default '24002400',
  CRED_FX3     CHAR(2)  default '00',
  FX_3         CHAR(8)  default '24002400',
  CRED_FX4     CHAR(2)  default '00',
  FX_4         CHAR(8)  default '24002400',
  CRED_FX5     CHAR(2)  default '00',
  FX_5         CHAR(8)  default '24002400',
  CRED_FX6     CHAR(2)  default '00',
  FX_6         CHAR(8)  default '24002400',
  ULTPAS_REF   CHAR(10) default '          ',
  TITULAR      CHAR(12) default '            ',
  GRUPO1       CHAR(3)  default '000',
  DATINIG1     CHAR(10) default '          ',
  DATFIMG1     CHAR(10) default '          ',
  GRUPO2       CHAR(3)  default '000',
  DATINIG2     CHAR(10) default '          ',
  DATFIMG2     CHAR(10) default '          ',
  GRUPO3       CHAR(3)  default '000',
  DATINIG3     CHAR(10) default '          ',
  DATFIMG3     CHAR(10) default '          ',
  GRUPO_SAB    CHAR(3)  default '000',
  GRUPO_DOM    CHAR(3)  default '000',
  GRUPO_FER    CHAR(3)  default '000',
  ANTI_DUPLA   CHAR(1)  default '1' 		NOT NULL CONSTRAINT anti_d CHECK (anti_dupla IN ('0','1')),
  BLOQ_FALTA   CHAR(1)  default '0'		NOT NULL CONSTRAINT bloq_f CHECK (bloq_falta IN ('0','1')),
  VER_HORA     CHAR(1)  default '1'		NOT NULL CONSTRAINT v_hora CHECK (ver_hora IN ('0','1', '2', '3')),
  VER_LOCAL    CHAR(1)  default '1'		NOT NULL CONSTRAINT v_local CHECK (ver_local IN ('0','1')),
  VER_VALID    CHAR(1)  default '1'		NOT NULL CONSTRAINT v_valid CHECK (ver_valid IN ('0','1')),
  VER_AFAST    CHAR(1)  default '1'		NOT NULL CONSTRAINT v_afast CHECK (ver_afast IN ('0','1')),
  VER_CRED     CHAR(1)  default '1'		NOT NULL CONSTRAINT v_cred CHECK (ver_cred IN ('0','1', '2', '3')),
  VIS_ESP      CHAR(1)  default '0'		NOT NULL CONSTRAINT v_vis CHECK (vis_esp IN ('0','1')),
  SEQUENCIA    NUMBER,
  NUMSERIAL    CHAR(10) default '0000000000'	NOT NULL,
  VER_DIGIT    CHAR(1)	default '2'		NOT NULL CONSTRAINT v_digit CHECK (ver_digit IN ('1', '2')),
  TEMPO_RET    CHAR(3)  default '000'		NOT NULL CONSTRAINT tempo_ret CHECK (to_number(tempo_ret)>=0),
  TOLER_RET    CHAR(3)  default '000'		NOT NULL CONSTRAINT toler_ret CHECK (to_number(toler_ret)>=0),
  VER_RET      CHAR(1)  default '0'		NOT NULL CONSTRAINT v_ret CHECK (ver_ret IN ('0','1')),
  TEMPO_JORNADA CHAR(3) default '540' 		NOT NULL CONSTRAINT tpo_jornada CHECK (to_number(TEMPO_JORNADA) >= 0),
  VER_SAIDAMAX CHAR(1)  default '0'		NOT NULL CONSTRAINT v_saidamax CHECK (ver_saidamax IN ('0','1')),
  ULTRSEG		CHAR(2) default '00'	NOT NULL 
)
  CLUSTER CONTFXHOR (ICARD);

CREATE UNIQUE INDEX INDEX1_CONTROLE ON CONTROLE (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 400K NEXT 20K);
CREATE INDEX INDEX2_CONTROLE ON CONTROLE (TITULAR) TABLESPACE ACESINDX STORAGE (INITIAL 400K NEXT 20K);
CREATE INDEX INDEX3_CONTROLE ON CONTROLE (NUMSERIAL) TABLESPACE ACESINDX STORAGE (INITIAL 400K NEXT 20K);

@@TRIGCONT;

-- *******************************************************

CREATE TABLE FXHORARIA (
ICARD CHAR(12) NOT NULL,
FX_DOM_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SEG_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_TER_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_QUA_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_QUI_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SEX_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SAB_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_DOM_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SEG_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_TER_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_QUA_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_QUI_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SEX_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SAB_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_REF   CHAR(56) default '24002400240024002400240024002400240024002400240024002400' NOT NULL)
CLUSTER CONTFXHOR (ICARD);

CREATE UNIQUE INDEX INDEX1_FXHORARIA ON FXHORARIA (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 400K NEXT 20K);
CREATE INDEX INDEX1_CONTFXHOR ON CLUSTER CONTFXHOR TABLESPACE ACESINDX STORAGE (INITIAL 400K NEXT 20K);

-- *******************************************************

CREATE TABLE CONTDIG (
  ICARD 	CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160),
  TEMPL_TIT2	CHAR(160),
  TEMPL_TIT3	CHAR(160),
  TEMPL_TIT4	CHAR(160),
  TEMPL_ALT1	CHAR(160),
  TEMPL_ALT2	CHAR(160),
  TEMPL_ALT3	CHAR(160),
  TEMPL_ALT4	CHAR(160),
  NIVEL		CHAR(1),
  NUM_DEDO_PAD  CHAR(2),
  NUM_DEDO_ALT  CHAR(2))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_CONTDIG ON CONTDIG (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);

-- *******************************************************

CREATE TABLE CONTDIG_VERI (
  ICARD 	CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160),
  TEMPL_TIT2	CHAR(160),
  TEMPL_TIT3	CHAR(160),
  TEMPL_TIT4	CHAR(160),
  TEMPL_ALT1	CHAR(160),
  TEMPL_ALT2	CHAR(160),
  TEMPL_ALT3	CHAR(160),
  TEMPL_ALT4	CHAR(160),
  TEMPL_TIT5    CHAR(56),
  TEMPL_ALT5    CHAR(56),
  NIVEL		CHAR(1),
  NUM_DEDO_PAD  CHAR(2),
  NUM_DEDO_ALT  CHAR(2))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_CONTDIG_VERI ON CONTDIG_VERI (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);


-- *******************************************************

CREATE TABLE CONTDIG_OMOK (
  ICARD 		CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160),
  TEMPL_TIT2	CHAR(160),
  TEMPL_TIT3	CHAR(160),
  TEMPL_TIT4	CHAR(160),
  TEMPL_TIT5    CHAR(160),
  TEMPL_TIT6    CHAR(26),
  TEMPL_ALT1	CHAR(160),
  TEMPL_ALT2	CHAR(160),
  TEMPL_ALT3	CHAR(160),
  TEMPL_ALT4	CHAR(160),
  TEMPL_ALT5    CHAR(160),
  TEMPL_ALT6    CHAR(26),
  TEMPL_COA1	CHAR(160),
  TEMPL_COA2	CHAR(160),
  TEMPL_COA3	CHAR(160),
  TEMPL_COA4	CHAR(160),
  TEMPL_COA5    CHAR(160),
  TEMPL_COA6    CHAR(26),
  NIVEL		CHAR(1),
  NUM_DEDO_PAD  CHAR(2),
  NUM_DEDO_ALT  CHAR(2),
  NUM_DEDO_COA  CHAR(2),
  ST_PAD	CHAR(1) DEFAULT '0',
  ST_ALT	CHAR(1) DEFAULT '0',
  ST_COA	CHAR(1) DEFAULT '0',
  GRUPO_TIT	CHAR(2) DEFAULT '00',
  GRUPO_ALT	CHAR(2) DEFAULT '00'
)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 8M NEXT 2M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_CONTDIG_OMOK ON CONTDIG_OMOK (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);
CREATE INDEX INDEX2_CONTDIG_OMOK ON CONTDIG_OMOK (GRUPO_TIT) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);
CREATE INDEX INDEX3_CONTDIG_OMOK ON CONTDIG_OMOK (GRUPO_ALT) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);

-- *******************************************************

CREATE TABLE CONTDIG_SAGEM (
  ICARD 		CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160),
  TEMPL_TIT2	CHAR(160),
  TEMPL_TIT3	CHAR(160),
  TEMPL_TIT4	CHAR(32),
  TEMPL_ALT1	CHAR(160),
  TEMPL_ALT2	CHAR(160),
  TEMPL_ALT3	CHAR(160),
  TEMPL_ALT4	CHAR(32),
  TEMPL_COA1	CHAR(160),
  TEMPL_COA2	CHAR(160),
  TEMPL_COA3	CHAR(160),
  TEMPL_COA4	CHAR(32),
  NIVEL		CHAR(1) default '0',
  NUM_DEDO_PAD  CHAR(2) default '00',
  NUM_DEDO_ALT  CHAR(2) default '00',
  NUM_DEDO_COA  CHAR(2) default '00',
  STATUS 	CHAR(1)	DEFAULT '0'
)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 8M NEXT 2M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_CONTDIG_SAGEM ON CONTDIG_SAGEM (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);

@@TRIGCONTSAG;

-- *******************************************************

CREATE TABLE CONTDIG_TSI1 (
  ICARD 	CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160),
  TEMPL_TIT2	CHAR(160),
  TEMPL_TIT3	CHAR(160),
  TEMPL_TIT4	CHAR(160),
  TEMPL_TIT5	CHAR(128),
  TEMPL_ALT1	CHAR(160),
  TEMPL_ALT2	CHAR(160),
  TEMPL_ALT3	CHAR(160),
  TEMPL_ALT4	CHAR(160),
  TEMPL_ALT5	CHAR(128),
  TEMPL_COA1	CHAR(160),
  TEMPL_COA2	CHAR(160),
  TEMPL_COA3	CHAR(160),
  TEMPL_COA4	CHAR(160),
  TEMPL_COA5	CHAR(128),
  NIVEL		CHAR(1) default '0',
  NUM_DEDO_PAD  CHAR(2) default '00',
  NUM_DEDO_ALT  CHAR(2) default '00',
  NUM_DEDO_COA  CHAR(2) default '00',
  STATUS 	CHAR(1)	DEFAULT '0'
)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 8M NEXT 2M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_CONTDIG_TSI1 ON CONTDIG_TSI1 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);

@@TRIGGRBIO.sql;

-- *******************************************************

CREATE TABLE FERIADO (
  DATA_FER 		DATE 	NOT NULL,
  DESC_FER		CHAR(30),
  PLANTA_FER	CHAR(3) default '000')
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 10K NEXT 1K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_FERIADO ON FERIADO (DATA_FER, PLANTA_FER) TABLESPACE ACESINDX STORAGE (INITIAL 10K NEXT 1K);


-- *******************************************************

CREATE TABLE DAT07 (
  END_IP	VARCHAR2(15) 	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip1 CHECK ((length(end_ip) = 15) and (end_ip NOT IN ('               '))),
  BLUEB     CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_blueb1 CHECK (to_number(blueb) >= 0),
  CODIN     CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_codin1 CHECK ((to_number(codin) >= 0) and (to_number(codin) <= 11)),
  DESC_END	CHAR(30),
  LACES     CHAR(3) NOT NULL CONSTRAINT tp_laces1 CHECK (to_number(laces) >= 0),       
  TIP_TERM  CHAR(1) NOT NULL CONSTRAINT tp_term CHECK (tip_term IN ('1','2','3','4', '5')),
  FUSO		CHAR(4) DEFAULT '0000' NOT NULL,
  PLANTA	CHAR(3) DEFAULT '000' NOT NULL,
  BIO_TIPO	CHAR(1) DEFAULT '0' NOT NULL CONSTRAINT bio_TIPO CHECK (bio_tipo IN ('0','1','2','3','4','5', '6', '7', '8')),
  TIP_LEIT 	CHAR(1) DEFAULT '0' NOT NULL,
  ATUFORC 	CHAR(1) DEFAULT '0',
  DATFORC	DATE,
  RASTREADOR	CHAR(1)	 DEFAULT '0' NOT NULL,
  POS_INIHALM	 CHAR(1) DEFAULT '0' NOT NULL CONSTRAINT pos_ihalm CHECK (pos_inihalm IN ('0','1','2','3')),
  POS_FIMHALM	 CHAR(1) DEFAULT '0' NOT NULL CONSTRAINT pos_falm CHECK (pos_fimhalm IN ('0','1','2','3')),
  VALID_RET	 CHAR(1) DEFAULT '0' NOT NULL CONSTRAINT b_ret CHECK (valid_ret IN ('0','1')),
  VALID_SAIDAMAX CHAR(1) DEFAULT '0' NOT NULL CONSTRAINT S_max CHECK (valid_saidamax IN ('0','1')),
  POSVALPLACA	CHAR(1)	DEFAULT '0'  NOT NULL CONSTRAINT pos_valplaca CHECK (POSVALPLACA in ('0', '1', '2', '3')),
  POSMENSBLOQ	CHAR(1)	DEFAULT '0'  NOT NULL CONSTRAINT pos_mbloq CHECK (POSMENSBLOQ in ('0', '1', '2', '3'))  
)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 100K NEXT 100K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_DAT07 ON DAT07 (BLUEB, CODIN, END_IP) TABLESPACE ACESINDX STORAGE (INITIAL 30K NEXT 3K);
CREATE UNIQUE INDEX INDEX2_DAT07 ON DAT07 (END_IP, BLUEB, CODIN) TABLESPACE ACESINDX STORAGE (INITIAL 30K NEXT 3K);
CREATE INDEX INDEX3_DAT07 ON DAT07 (LACES, PLANTA) TABLESPACE ACESINDX STORAGE (INITIAL 20K NEXT 2K);
       

-- *******************************************************

CREATE TABLE DAT08 (
  GRUPO          CHAR(3) NOT NULL,
  LACES          CHAR(3) NOT NULL CONSTRAINT tp_laces2 CHECK (to_number(laces) >= 0),
  FXPERM         CHAR(56) DEFAULT '00002400000024000000240000002400000024000000240000002400' NOT NULL,
  PLANTA	 CHAR(3) DEFAULT '000' NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 150K NEXT 20K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_DAT08 ON DAT08 (GRUPO, LACES, PLANTA) TABLESPACE ACESINDX STORAGE (INITIAL 30K NEXT 3K);
CREATE INDEX INDEX2_DAT08 ON DAT08 (LACES, PLANTA) TABLESPACE ACESINDX STORAGE (INITIAL 30K NEXT 3K);

-- *******************************************************

CREATE TABLE CP_BN (
  END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
  BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
  AVISO        CHAR(2)   NOT NULL,
  ST           CHAR(1)   NOT NULL,
  TERM         CHAR(2)   DEFAULT '00' NOT NULL,
  EPN3         CHAR(30))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 2M NEXT 100K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_CPBN ON CP_BN (AVISO, BLUEB, TERM, END_IP) tablespace ACESINDX STORAGE (INITIAL 900K NEXT 50K);
CREATE UNIQUE INDEX INDEX2_CPBN ON CP_BN (AVISO, END_IP, BLUEB, TERM) tablespace ACESINDX STORAGE (INITIAL 900K NEXT 50K);

-- *******************************************************

CREATE TABLE CP_NB (
  END_IP       VARCHAR2(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip2 CHECK ((length(end_ip) = 15) and (end_ip NOT IN ('               '))),
  BLUEB	       CHAR(2)  DEFAULT '00' NOT NULL CONSTRAINT tp_blueb2 CHECK (to_number(blueb) >= 0),
  CODIN        CHAR(2)  DEFAULT '00' NOT NULL CONSTRAINT tp_codin2 CHECK ((to_number(codin) >= 0) and (to_number(codin) <= 11)),   
  ST	       CHAR(1)	NOT NULL,
  CC 	       CHAR(2)	NOT NULL,
  TIPO_CC      CHAR(1)	NOT NULL CONSTRAINT tp_cc CHECK (tipo_cc IN ('0','1')),
  ACAO	       CHAR(15))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 40K NEXT 5K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_CPNB ON CP_NB (BLUEB, CODIN, TIPO_CC, END_IP) TABLESPACE ACESINDX STORAGE (INITIAL 5K NEXT 2K);
CREATE UNIQUE INDEX INDEX2_CPNB ON CP_NB (END_IP, TIPO_CC, BLUEB, CODIN) TABLESPACE ACESINDX STORAGE (INITIAL 5K NEXT 2K);
CREATE INDEX INDEX3_CPNB ON CP_NB (ST, BLUEB, CODIN, END_IP) TABLESPACE ACESINDX STORAGE (INITIAL 5K NEXT 2K);

-- *******************************************************

--@@TRG_COM;

-- *******************************************************

CREATE TABLE DAM00 (
  ICARD		CHAR(12)	NOT NULL,
  DIAM		CHAR(2)	NOT NULL,
  MESM		CHAR(2)	NOT NULL,
  ANOM		CHAR(2)	NOT NULL,
  HORAM		CHAR(4)	NOT NULL,
  SEGUNDO	CHAR(2)	NOT NULL,
  CODAC		CHAR(2)	NOT NULL,
  POSIC		CHAR(1)	NOT NULL,
  BLUEB		CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT		CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC	CHAR(2)	NOT NULL,
  VEICULO	VARCHAR2(15),
  ONOFF		CHAR(1),
  PESO		NUMBER(5,3),
  VALKILO	NUMBER(6,2),
  VALOR		NUMBER(6,2),
  QTDE		CHAR(2),
  TIPODOC CHAR(2) DEFAULT '00')
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 15M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************

CREATE TABLE DAM01 (
  ICARD		CHAR(12)	NOT NULL,
  DIAM		CHAR(2)		NOT NULL,
  MESM		CHAR(2)		NOT NULL,
  ANOM		CHAR(2)		NOT NULL,
  HORAM		CHAR(4)		NOT NULL,
  SEGUNDO	CHAR(2)		NOT NULL,
  CODAC		CHAR(2)		NOT NULL,
  POSIC		CHAR(1)		NOT NULL,
  BLUEB		CHAR(2)		DEFAULT '00' NOT NULL,
  CODTT		CHAR(2)		DEFAULT '00' NOT NULL,
  END_IP	CHAR(15)	DEFAULT '000.000.000.000'  NOT NULL,
  CODFNC	CHAR(2)		NOT NULL,
  VEICULO	VARCHAR2(15),
  PESO		NUMBER(5,3),
  VALKILO	NUMBER(6,2),
  VALOR		NUMBER(6,2),
  QTDE		CHAR(2),
  NIVEL		CHAR(2),
  FX_REF	CHAR(2),
  CRED_FX	CHAR(2),
  SITUA		CHAR(2),
  QTD_MENS	CHAR(2),
  TIPODOC CHAR(2) DEFAULT '00')
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 10M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************

CREATE TABLE DAM02 (
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)        NOT NULL,
  CODAC          CHAR(2)	NOT NULL,
  POSIC          CHAR(1)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000'  NOT NULL,
  CODFNC	 CHAR(2)	NOT NULL,
  VEICULO	 VARCHAR2(15),
  PESO 		 NUMBER(5,3),
  VALKILO 	 NUMBER(6,2),
  VALOR 	 NUMBER(6,2),
  QTDE 		 CHAR(2),
  TIPODOC CHAR(2) DEFAULT '00')
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 10M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************

CREATE TABLE DAM03 (
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)        NOT NULL,
  CODAC          CHAR(2)	NOT NULL,
  POSIC          CHAR(1)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000'  NOT NULL,
  CODFNC	 CHAR(2)	NOT NULL,
  VEICULO	 VARCHAR2(15),
  PESO 		 NUMBER(5,3),
  VALKILO 	 NUMBER(6,2),
  VALOR 	 NUMBER(6,2),
  QTDE 		 CHAR(2),
  TIPODOC 	CHAR(2) DEFAULT '00'  )
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 10M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************

CREATE TABLE DAT09 (
  ICARD          CHAR (12) NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 100K NEXT 100K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_DAT09 ON DAT09 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 5K);

-- *******************************************************

CREATE TABLE SNBE (
  BLUEB          CHAR(2) NOT NULL CONSTRAINT tp_blueb3 CHECK (to_number(blueb) >= 0),
  SINAL          CHAR(1) NOT NULL  CONSTRAINT tp_sinal1 CHECK (sinal IN ('0','1','2','3','4','8','9')),
  SEQUENCIA      NUMBER)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 10K NEXT 10K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_SNBE ON SNBE (BLUEB) TABLESPACE ACESINDX STORAGE (INITIAL 10K NEXT 10K);

@@TRIGSNBE;


-- *******************************************************

CREATE TABLE SBBE (
  SINAL         CHAR(1) NOT NULL CONSTRAINT tp_sinal2 CHECK (sinal IN ('0','1')),
  SEQUENCIA     NUMBER)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 100K NEXT 100K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

@@TRIGSBBE;


-- *******************************************************

CREATE TABLE TABALARME (
  END_IP       CHAR(15)  DEFAULT '000.000.000.000'  NOT NULL,
  BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
  TERM         CHAR(2)   DEFAULT '00' NOT NULL,
  ALARME       CHAR(2)   NOT NULL,
  STATUS       CHAR(1)   NOT NULL,
  INFORM       CHAR(15))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************

CREATE TABLE TABDEV(
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)        NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000'  NOT NULL,
  LISTA  	 VARCHAR2(15),
  STATUS         CHAR(1))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 5M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************

CREATE TABLE MAPABIO (
  ICARD	       CHAR(12)  NOT NULL,
  END_IP       CHAR(15)  DEFAULT '000.000.000.000'  NOT NULL,
  TIPO_TEMPL   CHAR(1)   NOT NULL,
  NIVEL	       CHAR(1)   NOT NULL,
  BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
  CODIN        CHAR(2)   DEFAULT '00' NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 2M NEXT 2M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_MAPABIO ON MAPABIO (ICARD, END_IP, TIPO_TEMPL, BLUEB, CODIN) TABLESPACE ACESINDX STORAGE (INITIAL 1M NEXT 100K);
CREATE UNIQUE INDEX INDEX2_MAPABIO ON MAPABIO (END_IP, ICARD, TIPO_TEMPL, BLUEB, CODIN) TABLESPACE ACESINDX STORAGE (INITIAL 1M NEXT 100K);
CREATE UNIQUE INDEX INDEX3_MAPABIO ON MAPABIO (ICARD, BLUEB, CODIN,  TIPO_TEMPL, END_IP) TABLESPACE ACESINDX STORAGE (INITIAL 1M NEXT 100K);
CREATE UNIQUE INDEX INDEX4_MAPABIO ON MAPABIO ( BLUEB, CODIN, ICARD, TIPO_TEMPL, END_IP) TABLESPACE ACESINDX STORAGE (INITIAL 1M NEXT 100K);

-- *******************************************************

CREATE TABLE SITENTRADA  (
  END_IP       CHAR(15)  DEFAULT '000.000.000.000'  NOT NULL,
  BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
  CODTT         CHAR(2)   DEFAULT '00' NOT NULL,
  DATA_ALARME  DATE		NOT NULL,
  ENTRADAS     CHAR(30)		NOT NULL,
  LOCAL_OCORR  CHAR(30)		NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 5M NEXT 5M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************

CREATE TABLE CONTFUNC  (
  ICARD       CHAR(12)   NOT NULL,
  CODFUNC     CHAR(2)   DEFAULT '00' NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_CONTFUNC ON CONTFUNC (ICARD, CODFUNC) TABLESPACE ACESINDX STORAGE (INITIAL 500K NEXT 100K);


-- *******************************************************

CREATE TABLE TERMBENEF (
  END_IP	VARCHAR2(15)	DEFAULT '000.000.000.000'  NOT NULL CONSTRAINT tp_endip3 CHECK ((length(end_ip) = 15) and (end_ip NOT IN ('               '))),
  BLUEB		CHAR(02)	DEFAULT '00'  NOT NULL CONSTRAINT tp_blueb4 CHECK (to_number(blueb) >= 0),
  TERM		CHAR(2)		DEFAULT '00'  NOT NULL CONSTRAINT tp_codin3 CHECK ((to_number(term) >= 0) and (to_number(term) <= 11)),  
  LBENEF 	VARCHAR2(15)	NOT NULL CONSTRAINT nome_benef CHECK (LBENEF BETWEEN 'LBENEF00' AND 'LBENEF09' OR LBENEF BETWEEN 'LBENEF10' AND 'LBENEF19' OR LBENEF BETWEEN 'LBENEF20' AND 'LBENEF23'),
  IND_LIS 	CHAR(2)		NOT NULL CONSTRAINT ind_benef CHECK (TO_NUMBER(ind_lis) BETWEEN 0 AND 23))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 50K NEXT 50K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_TERMBENEF ON TERMBENEF (BLUEB,TERM, END_IP) TABLESPACE ACESINDX STORAGE (INITIAL 10K NEXT 5K);
CREATE UNIQUE INDEX INDEX2_TERMBENEF ON TERMBENEF (END_IP, BLUEB, TERM) TABLESPACE ACESINDX STORAGE (INITIAL 10K NEXT 5K);

-- *************************** LISTAS DE BENEFICIOS *************************************

CREATE TABLE BENEFICIO(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1K NEXT 1K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_BENEFICIO ON BENEFICIO (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);

-- *******************************************************

CREATE TABLE LBENEF00(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF00 ON LBENEF00 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);

 
-- *******************************************************

CREATE TABLE LBENEF01(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF01 ON LBENEF01 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);

  
-- *******************************************************

CREATE TABLE LBENEF02(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF02 ON LBENEF02 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF03(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF03 ON LBENEF03 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF04(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF04 ON LBENEF04 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF05(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF05 ON LBENEF05 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF06(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF06 ON LBENEF06 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF07(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF07 ON LBENEF07 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF08(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF08 ON LBENEF08 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF09(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF09 ON LBENEF09 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF10(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF10 ON LBENEF10 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF11(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF11 ON LBENEF11 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF12(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF12 ON LBENEF12 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF13(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF13 ON LBENEF13 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF14(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF14 ON LBENEF14 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF15(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF15 ON LBENEF15 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF16(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF16 ON LBENEF16 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF17(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF17 ON LBENEF17 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);

-- *******************************************************

CREATE TABLE LBENEF18(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF18 ON LBENEF18 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF19(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF19 ON LBENEF19 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF20(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF20 ON LBENEF20 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF21(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF21 ON LBENEF21 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF22(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF22 ON LBENEF22 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE LBENEF23(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_LBENEF23 ON LBENEF23 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE INFOMAT (
  CAMPO_BLOQ	CHAR(5) NOT NULL CONSTRAINT ck_cpo_bloq CHECK (campo_bloq IN ('SAD','TIPO')),
  POS_INIC	CHAR(2) NOT NULL CONSTRAINT ck_pos_bloq CHECK (TO_NUMBER(pos_inic) BETWEEN 1 AND 12),
  TAMANHO	CHAR(1) NOT NULL CONSTRAINT ck_tam_bloq CHECK (TO_NUMBER(tamanho) BETWEEN 1 AND 9))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_INFOMAT ON INFOMAT (CAMPO_BLOQ) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE BLOQSAD (
  SAD		CHAR(9),
  BLOQUEADO	CHAR(1))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_BLOQSAD ON BLOQSAD (SAD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE BLOQTIPO (
  TIPO		CHAR(9),
  BLOQUEADO	CHAR(1))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_BLOQTIPO ON BLOQTIPO (TIPO) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE EXCESAD (
  ICARD        CHAR(12) NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_EXCESAD ON EXCESAD (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE EXCETIPO (
  ICARD        CHAR(12) NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 4K NEXT 2K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_EXCETIPO ON EXCETIPO (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 1K NEXT 1K);


-- *******************************************************

CREATE TABLE ATUALI (
  IDENTIF		CHAR(14)	NOT NULL,
  NUMSERIAL	CHAR(10)	NOT NULL,
  ICARD		CHAR(12),
  NUMCPO		CHAR(2)		NOT NULL,
  INFORM		VARCHAR2(56)	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 2M NEXT 2M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


CREATE UNIQUE INDEX INDEX1_ATUALI ON ATUALI (IDENTIF) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

--CREATE INDEX INDEX2_ATUALI ON ATUALI (NUMSERIAL, to_identif(IDENTIF)) 
CREATE INDEX INDEX2_ATUALI ON ATUALI (NUMSERIAL, IDENTIF) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

-- *******************************************************


CREATE TABLE LIMPATU (
  IDENTIF	CHAR(14)	NOT NULL,
  NUMSERIAL	CHAR(10)	NOT NULL,
  DATA_ATU	CHAR(10),
  END_IP        CHAR(15)  DEFAULT '000.000.000.000',
  BLUEB         CHAR(2)   DEFAULT '00',
  CODTT         CHAR(2)   DEFAULT '00',
  MODO_ATU	CHAR(1)	  DEFAULT '0',
  STATUS        CHAR(1)	  DEFAULT '0')
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE INDEX INDEX1_LIMPATU ON LIMPATU (IDENTIF) TABLESPACE ACESINDX STORAGE (INITIAL 120K NEXT 15K);


-- *******************************************************

CREATE TABLE CONTVEI (
  ICARD         CHAR(12) NOT NULL,
  ICARDV	CHAR(12) NOT NULL,
  DATAHORA	CHAR(10) DEFAULT '3112202359' NOT NULL,
  SITUA 	CHAR(1)  DEFAULT '0' NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 500K NEXT 500K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_CONTVEI ON CONTVEI (ICARD, ICARDV) TABLESPACE ACESINDX STORAGE (INITIAL 120K NEXT 15K);


-- *******************************************************

CREATE TABLE PENDSMART (
    END_IP 	CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
    BLUEB	CHAR(2)		DEFAULT '00' NOT NULL CONSTRAINT tp_blueb5 CHECK (to_number(blueb) >= 0),
    CODIN 	CHAR(2)		DEFAULT '00' NOT NULL CONSTRAINT tp_codin5 CHECK ((to_number(codin) >= 0) and (to_number(codin) <= 11)),
    NUMSERIAL	CHAR(10)	NOT NULL,
    IDENTIF	CHAR(14)	NOT NULL,
    NUMCPO	CHAR(2)		DEFAULT '  ',
    INFORM	VARCHAR2(56)	DEFAULT '                    ')
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE INDEX INDEX1_PENDSMART ON PENDSMART(END_IP, BLUEB, CODIN, NUMSERIAL, IDENTIF) TABLESPACE ACESINDX STORAGE (INITIAL 120K NEXT 15K);
CREATE INDEX INDEX2_PENDSMART ON PENDSMART(BLUEB, CODIN, END_IP, NUMSERIAL, IDENTIF) TABLESPACE ACESINDX STORAGE (INITIAL 120K NEXT 15K);

-- *******************************************************

CREATE TABLE EXPIREATU (
  IDENTIF	CHAR(14)	NOT NULL,
  NUMSERIAL	CHAR(10)	NOT NULL,
  DATA_EXP	CHAR(10),
  END_IP	CHAR(15)  DEFAULT '000.000.000.000',
  BLUEB		CHAR(2)   DEFAULT '00',
  CODTT         CHAR(2)   DEFAULT '00')
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************

CREATE TABLE CREDLOG (
  ICARD	CHAR(12) NOT NULL,
  ANO		CHAR(4) DEFAULT '0000' NOT NULL,
  MES		CHAR(2) DEFAULT '00' NOT NULL,
  DIA		CHAR(2) DEFAULT '00' NOT NULL,
  HORA	CHAR(4) DEFAULT '0000' NOT NULL,
  SEGUNDO	CHAR(2) DEFAULT '00' NOT NULL,
  TIPO	CHAR(1) NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE INDEX INDEX1_CREDLOG ON CREDLOG (ICARD,TIPO) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);

-- *******************************************************

CREATE TABLE VEICULO (
  ICARDV	CHAR(12) NOT NULL,
  NUMSERIAL     CHAR(10) default '0000000000'	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE INDEX INDEX1_VEICULO ON VEICULO (ICARDV) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);

-- *******************************************************

CREATE TABLE COUNT_BY_VEIC (
  ICARDV primary key,
  CNT,
  CONSTRAINT cnt_ate_60 CHECK ( cnt < 61 ) DEFERRABLE INITIALLY DEFERRED)
ORGANIZATION INDEX AS 
   SELECT icardv, count(*) from CONTVEI GROUP BY icardv;

@@TRIGVEIC;

-- *******************************************************

CREATE TABLE SITCOLETOR (
  ENDIP 	CHAR(15) NOT NULL,
  BLUEB 	CHAR(2)	 NOT NULL,
  CODIN 	CHAR(2)  NOT NULL,
  ID_CONEX 	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  DISPOSITIVO 	CHAR(1)  DEFAULT '1' NOT NULL,
  STATUS	CHAR(1)	 DEFAULT '0' NOT NULL,
  LSTPEND	CHAR(5)	 DEFAULT '     ',
  LSTLOGS	CHAR(5)  DEFAULT '     ',
  DT_ATUALI	DATE )  
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 500K NEXT 500K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE INDEX INDEX1_SITCOLETOR ON SITCOLETOR (ENDIP,BLUEB,CODIN) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);
CREATE INDEX INDEX2_SITCOLETOR ON SITCOLETOR (BLUEB,CODIN,ENDIP) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);


-- *******************************************************

CREATE TABLE PEND_ON001 (
   IDENTIF 		CHAR(14)	NOT NULL,
   NUMSERIAL	CHAR(10)	NOT NULL,
   ICARD		CHAR(12),
   TIPO         CHAR(1)  default ' ',       
   NUMCPO		CHAR(2)		NOT NULL,
   INFORM		VARCHAR2(56)	NOT NULL,
   END_IP       CHAR(15)  DEFAULT '000.000.000.000',
   BLUEB        CHAR(2)   DEFAULT '00',
   CODIN        CHAR(2)   DEFAULT '00',
   DATA_EXP		DATE,
   STATUS   	CHAR(1)   DEFAULT '0',
   TIPO_ATU		CHAR(1)	  DEFAULT '1')
 PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


CREATE INDEX INDEX1_PEND_ON001 ON PEND_ON001 (NUMSERIAL, END_IP, IDENTIF) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 5M NEXT 20M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE INDEX INDEX2_PEND_ON001 ON PEND_ON001 (END_IP, TIPO_ATU) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 5M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );
 

-- *******************************************************

--CREATE TABLE PEND_ON002 (
--   END_IP       CHAR(15)  DEFAULT '000.000.000.000',
--   BLUEB        CHAR(2)   DEFAULT '00',
--   CODIN        CHAR(2)   DEFAULT '00',
--   QTD_LIVRE    NUMBER,
--   STATUS   	CHAR(1)   DEFAULT '0',
--   QHOR_EXP	NUMBER	  DEFAULT 12,
--   DATA_INI	DATE,
--   QTD_LIVREOFF NUMBER,
--   STATUS_OFF   CHAR(1)	  DEFAULT '0',
--   QHOR_EXPOFF  NUMBER,
--   DATA_INIOFF  DATE,
--   STATUS_LPZ   CHAR(1)	  DEFAULT '0',
--   DATA_INILPZ	DATE) 	
--PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
--STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

-- *******************************************************
-- tab PEND_ON002ON
-- *******************************************************
CREATE TABLE PEND_ON002ON (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000',
   BLUEB        CHAR(2)   DEFAULT '00',
   CODIN        CHAR(2)   DEFAULT '00',
   QTD_LIVRE    NUMBER,
   STATUS   	CHAR(1)   DEFAULT '0',
   QHOR_EXP		NUMBER	  DEFAULT 12,
   QHOR_EXPOFF  NUMBER,
   DATA_INI		DATE )
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_PEND_ON002ON ON PEND_ON002ON (END_IP,BLUEB,CODIN)
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************
-- tab PEND_ON002OFF
-- *******************************************************
CREATE TABLE PEND_ON002OFF (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000',
   BLUEB        CHAR(2)   DEFAULT '00',
   CODIN        CHAR(2)   DEFAULT '00',
   QHOR_EXP		NUMBER	  DEFAULT 12,
   QTD_LIVREOFF NUMBER,
   STATUS_OFF   CHAR(1)	  DEFAULT '0',
   QHOR_EXPOFF  NUMBER,
   DATA_INIOFF  DATE) 
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_PEND_ON002OFF ON PEND_ON002OFF (END_IP,BLUEB,CODIN)
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************
-- tab PEND_ON002LPZ
-- *******************************************************
CREATE TABLE PEND_ON002LPZ (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000',
   BLUEB        CHAR(2)   DEFAULT '00',
   CODIN        CHAR(2)   DEFAULT '00',
   QHOR_EXP		NUMBER	  DEFAULT 12,
   QHOR_EXPOFF  NUMBER,
   STATUS_LPZ   CHAR(1)	  DEFAULT '0',
   DATA_INILPZ	DATE,
   HORA		VARCHAR(5) DEFAULT '99:99') 	
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_PEND_ON002LPZ ON PEND_ON002LPZ (END_IP,BLUEB,CODIN)
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );



-- *******************************************************

CREATE TABLE PEND_ON003 (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000',
   BLUEB        CHAR(2)   DEFAULT '00',
   CODIN        CHAR(2)   DEFAULT '00',
   NUMSERIAL	CHAR(10)	NOT NULL,
   IDENTIF	CHAR(14)	NOT NULL,
   QHOR_EXP	NUMBER	  DEFAULT 12) 	
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_PEND_ON003 ON PEND_ON003 (END_IP,BLUEB,CODIN,NUMSERIAL) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX2_PEND_ON003 ON PEND_ON003 (NUMSERIAL, END_IP) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );
 
-- *******************************************************

CREATE TABLE PEND_ON004 (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000',
   BLUEB        CHAR(2)   DEFAULT '00',
   CODIN        CHAR(2)   DEFAULT '00',
   NUMSERIAL	CHAR(10)  NOT NULL,
   IDENTIF	CHAR(14)  NOT NULL,
   NUMCPO	CHAR(2)	  NOT NULL,
   INFORM	CHAR(10)	  NOT NULL) 	
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

--CREATE UNIQUE INDEX INDEX1_PEND_ON004 ON PEND_ON004 (END_IP,BLUEB,CODIN,NUMSERIAL,to_number(NUMCPO)) 
CREATE UNIQUE INDEX INDEX1_PEND_ON004 ON PEND_ON004 (END_IP,BLUEB,CODIN,NUMSERIAL,NUMCPO) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************

-- criacao tabela PEND_ON005 (LISTA LIMPEZA)
--CREATE TABLE PEND_ON005 (
--   END_IP       CHAR(15)  DEFAULT '000.000.000.000',
--   BLUEB        CHAR(2)   DEFAULT '00',
--   CODIN        CHAR(2)   DEFAULT '00',
--   NUMSERIAL	CHAR(10)	NOT NULL,
--   IDENTIF	CHAR(14)	NOT NULL,
--   MODO_ATU	CHAR(1)) 	
--PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
--STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


--CREATE UNIQUE INDEX INDEX1_PEND_ON005 ON PEND_ON005 ( END_IP, BLUEB, CODIN, IDENTIF, NUMSERIAL, MODO_ATU ) 
-- TABLESPACE ACESINDX 
-- PCTFREE 10 INITRANS 50 MAXTRANS 255 
-- STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************

-- criacao tabela PEND_ON006 (lista auxiliar de limpeza)
--CREATE TABLE PEND_ON006 ( 
--  IDENTIF	CHAR(14) NOT NULL, 
--  NUMSERIAL	CHAR(10) NOT NULL, 
--  END_IP	CHAR(15) DEFAULT '000.000.000.000', 
--  BLUEB		CHAR(2) DEFAULT '00', 
--  CODIN		CHAR(2) DEFAULT '00', 
--  STATUS	CHAR(1) DEFAULT '0', 
--  MODO_ATU	CHAR(1) DEFAULT '1')  
--PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
--STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


--CREATE INDEX INDEX1_PEND_ON006 ON PEND_ON006 ( END_IP, MODO_ATU, STATUS ) 
-- TABLESPACE ACESINDX 
-- PCTFREE 10 INITRANS 50 MAXTRANS 255 
-- STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************

CREATE TABLE PEND_ON008ON (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000',
   BLUEB        CHAR(2)   DEFAULT '00',
   CODIN        CHAR(2)   DEFAULT '00',
   STATUS   	CHAR(1)   DEFAULT '0',
   QHOR_EXP		NUMBER	  DEFAULT 12) 
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_PEND_ON008ON ON PEND_ON008ON (END_IP) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************


CREATE TABLE PEND_ON008OFF (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000',
   BLUEB        CHAR(2)   DEFAULT '00',
   CODIN        CHAR(2)   DEFAULT '00',
   STATUS_OFF   CHAR(1)	  DEFAULT '0',
   QHOR_EXPOFF  NUMBER)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_PEND_ON008OFF ON PEND_ON008OFF (END_IP) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );



-- *******************************************************


CREATE TABLE PEND_ON008LPZ (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000',
   BLUEB        CHAR(2)   DEFAULT '00',
   CODIN        CHAR(2)   DEFAULT '00',
   STATUS_LPZ   CHAR(1)	  DEFAULT '0')
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_PEND_ON008LPZ ON PEND_ON008LPZ (END_IP) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );



-- *******************************************************

CREATE TABLE LOGPEND (
  IDENTIF 	char(14) not null,
--  INCLUSAO 	timestamp default CURRENT_TIMESTAMP not null,
  INCLUSAO 	date default sysdate not null,
  EVENTO 	char(2) not null,
  NUMSERIAL 	char(10) not null,
  ICARD  	char(12) not null,
  NUMCPO 	char(2) not null,
  INFORM 	varchar2(56) not null,
  END_IP 	char(15) default '000.000.000.000' not null,
  BLUEB  	char(2) DEFAULT '00',
  CODIN  	char(2) DEFAULT '00',
  IDENTIF_REF   char(14),
  TIPO_ATU	char(1) default '1') 
 PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 2M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE INDEX INDEX1_LOGPEND ON LOGPEND ( EVENTO ) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );
 

-- *******************************************************

CREATE TABLE PEND_GRUPO (
  ICARD			CHAR(12) NOT NULL,
  NUMSERIAL		CHAR(10) default '0000000000'	NOT NULL,
  GRUPO			CHAR(3)  default '000', 
  GRUPO_ANT		CHAR(3)  default '000', 
  GRUPO1		CHAR(3)  default '000',
  GRUPO1_ANT	CHAR(3)  default '000',
  GRUPO2		CHAR(3)  default '000',
  GRUPO2_ANT	CHAR(3)  default '000',
  GRUPO3		CHAR(3)  default '000',
  GRUPO3_ANT	CHAR(3)  default '000',
  GRUPO_SAB		CHAR(3)  default '000',
  GRUPO_SAB_ANT	CHAR(3)  default '000',
  GRUPO_DOM		CHAR(3)  default '000',
  GRUPO_DOM_ANT	CHAR(3)  default '000',
  GRUPO_FER		CHAR(3)  default '000',
  GRUPO_FER_ANT	CHAR(3)  default '000')
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 2M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_PEND_GRUPO ON PEND_GRUPO (ICARD) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE INDEX INDEX2_PEND_GRUPO ON PEND_GRUPO (NUMSERIAL) 
 TABLESPACE ACESINDX 
 PCTFREE 10 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

-- *******************************************************

CREATE GLOBAL TEMPORARY TABLE TMP_LISTAPENDENCIA 
( 
  END_IP CHAR(15), 
  NUMSERIAL CHAR(10), 
  IDENTIF CHAR(14) 
) 
ON COMMIT DELETE ROWS ;


-- *******************************************************
 
CREATE GLOBAL TEMPORARY TABLE TMP_CODINS 
( 
  IDENTIF CHAR(14), 
  NUMSERIAL CHAR(10), 
  ICARD  CHAR(12), 
  NUMCPO CHAR(2), 
  INFORM VARCHAR2(56), 
  END_IP CHAR(15) 
) 
ON COMMIT DELETE ROWS ;

-- *******************************************************

CREATE GLOBAL TEMPORARY TABLE TMP_LISTALIMPAOFF 
( 
  END_IP	CHAR(15), 
  NUMSERIAL	CHAR(10), 
  IDENTIF	CHAR(14),
  MODO_ATU	CHAR(1) 
) 
ON COMMIT DELETE ROWS ;


-- *******************************************************

CREATE GLOBAL TEMPORARY TABLE TMP_LISTAPENDENCIA_OFF
(
  END_IP	CHAR(15),
  NUMSERIAL	CHAR(10),
  IDENTIF	CHAR(14),
  TIPO_ATU	CHAR(1),
  NUMCPO	CHAR(2),
  INFORM	VARCHAR2(10)
)
ON COMMIT DELETE ROWS ;


-- *******************************************************

CREATE TABLE MATCODIN (
  ICARD 	CHAR(12) NOT NULL,
  END_IP	VARCHAR2(15) 	DEFAULT '000.000.000.000' NOT NULL,
  BLUEB		CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_blueb6 CHECK (to_number(blueb) >= 0),
  CODIN 	CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_codin6 CHECK ((to_number(codin) >= 0) and (to_number(codin) <= 11)),
  DIASEM	CHAR(1) DEFAULT '0' NOT NULL CONSTRAINT ck_diasem CHECK (TO_NUMBER(diasem) BETWEEN 0 AND 8),
  FXPERM        CHAR(56) DEFAULT '00002400000024000000240000002400000024000000240000002400' NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );
 
CREATE UNIQUE INDEX INDEX1_MATCODIN ON MATCODIN (ICARD, BLUEB, CODIN, DIASEM, END_IP) tablespace ACESINDX STORAGE (INITIAL 900K NEXT 50K);
CREATE UNIQUE INDEX INDEX2_MATCODIN ON MATCODIN (ICARD, END_IP, DIASEM, BLUEB, CODIN) tablespace ACESINDX STORAGE (INITIAL 900K NEXT 50K);

-- *******************************************************

CREATE TABLE CONTPLANTA (
  ICARD 	CHAR(12) NOT NULL,
  PLANTACESSO   CHAR(3) DEFAULT '000' NOT NULL,
  DATAHORA      CHAR(10) default '3112202359' NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_CONTPLANTA ON CONTPLANTA (ICARD,PLANTACESSO) tablespace ACESINDX STORAGE (INITIAL 900K NEXT 50K);


-- *******************************************************

CREATE TABLE GEOMOK001 (
  END_IP	VARCHAR2(15) 	DEFAULT '000.000.000.000' NOT NULL,
  BLUEB		CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_blueb7 CHECK (to_number(blueb) >= 0),
  CODIN 	CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_codin7 CHECK ((to_number(codin) >= 0) and (to_number(codin) <= 11)),
  NIVEL		CHAR(1)	DEFAULT '2' NOT NULL CONSTRAINT niv_geomok CHECK (to_number(nivel) BETWEEN 1 AND 7),
  NIVELSAG CHAR(2) DEFAULT '05' CONSTRAINT niv_SAGEN CHECK (to_number(nivelSAG) BETWEEN 0 AND 10))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_GEOMOK001 ON GEOMOK001 (END_IP, BLUEB, CODIN) tablespace ACESINDX STORAGE (INITIAL 900K NEXT 50K);
CREATE UNIQUE INDEX INDEX2_GEOMOK001 ON GEOMOK001 (BLUEB, CODIN, END_IP) tablespace ACESINDX STORAGE (INITIAL 900K NEXT 50K);

-- *******************************************************

CREATE TABLE DATAHORA (
  ICARD        CHAR(12) NOT NULL,
  INI_HALM     DATE default TO_DATE('01/01/2006 00:00:00', 'dd/mm/rrrr hh24:mi:ss') NOT NULL,
  FIM_HALM     DATE default TO_DATE('01/01/2006 00:00:00', 'dd/mm/rrrr hh24:mi:ss') NOT NULL,
  INI_INTJ     DATE default TO_DATE('01/01/2006 00:00:00', 'dd/mm/rrrr hh24:mi:ss') NOT NULL,
  FIM_INTJ     DATE default TO_DATE('01/01/2006 00:00:00', 'dd/mm/rrrr hh24:mi:ss') NOT NULL,
  FIM_ANTID	   DATE default TO_DATE('01/01/2006 00:00:00', 'dd/mm/rrrr hh24:mi:ss') NOT NULL
);

CREATE UNIQUE INDEX INDEX1_DATAHORA ON DATAHORA (ICARD) tablespace ACESINDX STORAGE (INITIAL 900K NEXT 50K);


-- *******************************************************

CREATE TABLE TABLOCKS (
  ICARD		CHAR(12) NOT NULL,
  DATAHORA  DATE default SYSDATE NOT NULL,
  USUARIO   CHAR(15) NOT NULL);

CREATE UNIQUE INDEX INDEX1_TABLOCKS ON TABLOCKS (ICARD) tablespace ACESINDX STORAGE (INITIAL 900K NEXT 50K);


-- *******************************************************

CREATE TABLE PEND_ON007 (
  IDENTIF 	char(14) not null,
  INCLUSAO 	date default sysdate not null,
  EVENTO 	char(2) not null,
  NUMSERIAL 	char(10) not null,
  ICARD  	char(12) not null,
  NUMCPO 	char(2) not null,
  INFORM 	varchar2(56) not null,
  END_IP 	char(15) default '000.000.000.000' not null,
  BLUEB  	char(2) DEFAULT '00',
  CODIN  	char(2) DEFAULT '00',
  IDENTIF_REF   char(14),
  TIPO_ATU	char(1) default '1') 
 PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
 STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************

CREATE GLOBAL TEMPORARY TABLE TMP_DIG001 
( 
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip6 CHECK ((length(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
) 
ON COMMIT DELETE ROWS ;

-- *******************************************************

CREATE GLOBAL TEMPORARY TABLE TMP_DIG003 
( 
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip7 CHECK ((length(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
) 
ON COMMIT DELETE ROWS ;

-- *******************************************************

CREATE TABLE DIG001 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip4 CHECK ((length(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 2M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_DIG001 ON DIG001 (ICARD,END_IP);

-- *******************************************************

CREATE TABLE DIG003 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip8 CHECK ((length(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 2M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_DIG003 ON DIG003 (ICARD,END_IP);

-- *******************************************************

CREATE TABLE DIG002 (
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip5 CHECK ((length(END_IP) = 15) and (END_IP NOT IN ('               '))),
  DATA_LOAD    date default sysdate not null,
  STATUS	CHAR(1),
  BIO_TIPO 	CHAR(1)
)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 2M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


CREATE UNIQUE INDEX INDEX1_DIG002 ON DIG002 (END_IP);

-- *******************************************************

-- criacao table DAT05
CREATE TABLE DAT05 (
  NUMSERIAL	CHAR(10)	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 100K NEXT 100K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_DAT05 ON DAT05 (NUMSERIAL) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 5K);

-- *******************************************************

CREATE TABLE SISINFO (
  NSISTEMA	NUMBER(3) NOT  NULL CONSTRAINT tp_nsistema1 CHECK (NSISTEMA > 0), 
  NVERSAO	VARCHAR(100),
  BASE		VARCHAR(30),
  DATINS    DATE DEFAULT SYSDATE NOT NULL,
  SEQ		NUMBER,
  LOCAL		VARCHAR(30),
  INFO		VARCHAR(250)
)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 10M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

@@TRIGSIS.sql;

-- *******************************************************

CREATE TABLE DSPMENS (
  END_IP    VARCHAR2(15)	NOT NULL CONSTRAINT tp_endip9 CHECK ((length(end_ip) = 15) and (end_ip NOT IN ('               '))),
  NSIST	   	CHAR(1) NOT  NULL  CONSTRAINT tp_nsistema2  CHECK (NSIST IN ('1','2')),		-- 1= CONEX, 2= CONEXREP
  ST	    CHAR(1) DEFAULT '0'	NOT NULL) 
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

-- indice para DSPMENS
CREATE UNIQUE INDEX INDEX1_DSPMENS ON DSPMENS (NSIST, END_IP) TABLESPACE ACESINDX STORAGE (INITIAL 5K NEXT 2K);

-- *******************************************************

CREATE TABLE CONTCPF (
ICARD CHAR(12) NOT NULL,
CPF	  CHAR(11)  NOT NULL,
REAL CHAR(11), 
TIPODOC CHAR(1) DEFAULT '2')
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

-- indice para CONTCPF
CREATE UNIQUE INDEX INDEX1_CONTCPF ON CONTCPF (CPF) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);
CREATE UNIQUE INDEX INDEX2_CONTCPF ON CONTCPF (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);


-- *******************************************************

CREATE TABLE DAM99 (
  ICARD		CHAR(12)	NOT NULL,
  NUMSERIAL	CHAR(10)	NOT NULL,
  DOCUMENTO	CHAR(14)	NOT NULL,
  DOC_TIPO	CHAR(1)	NOT NULL,
  PLACA		CHAR(10),
  DIAM		CHAR(2)	NOT NULL,
  MESM		CHAR(2)	NOT NULL,
  ANOM		CHAR(2)	NOT NULL,
  HORAM		CHAR(4)	NOT NULL,
  SEGUNDO	CHAR(2)	NOT NULL,
  CODAC		CHAR(2)	NOT NULL,
  POSIC		CHAR(1)	NOT NULL,
  BLUEB		CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT		CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC	CHAR(2)	NOT NULL,
  VEICULO	VARCHAR2(15),
  ONOFF		CHAR(1))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 15M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

-- *******************************************************

CREATE TABLE BDCC_CRACHA (
	CRACHA 		varchar(12) NOT NULL,
    BLOQUEADO 	NUMBER (1,0) NOT NULL CONSTRAINT tp_bloq1 CHECK (BLOQUEADO IN (0,1)))		-- 0= no bloqueado, 1= bloqueado
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 15M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


CREATE UNIQUE INDEX INDEX1_BDCC_CRACHA ON BDCC_CRACHA (CRACHA) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);



-- *******************************************************
CREATE TABLE DAT10 (
	ICARD 	CHAR(12) 	NOT NULL,
    PLACA 	VARCHAR(15) 	NOT NULL,
    HORAREC	DATE		NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 15M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


CREATE UNIQUE INDEX INDEX1_DAT10 ON DAT10 (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);

-- *******************************************************

CREATE TABLE DAT11 (
	ICARD 	CHAR(12) 	NOT NULL,
    PLACA 	VARCHAR(15) 	NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 15M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


CREATE UNIQUE INDEX INDEX1_DAT11 ON DAT11 (PLACA) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);


-- *******************************************************

-- MATBMENS
CREATE TABLE MATBMENS (
	ICARD 		CHAR(12) NOT NULL,
	FXMENS		CHAR(8) NOT NULL,
	MENSBLOQ	CHAR(32) NOT NULL)
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 15M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );

CREATE UNIQUE INDEX INDEX1_MATBMENS ON MATBMENS (ICARD, FXMENS) TABLESPACE ACESINDX STORAGE (INITIAL 400K NEXT 20K);


-- *******************************************************

CREATE TABLE REPPONTO (
  IFUNC		CHAR(12)	NOT NULL CONSTRAINT acrep_ct01 CHECK(translate(IFUNC,'A0123456789', 'A') is null and length(IFUNC) = 12),
  PIS		CHAR(12)	NOT NULL CONSTRAINT acrep_ct02 CHECK(translate(PIS,'A0123456789', 'A') is null and length(PIS) = 12),
  DTAHORAREP	DATE  NOT NULL
);

CREATE UNIQUE INDEX INDEX1_REPPONTO ON REPPONTO (IFUNC, PIS) tablespace ACESINDX STORAGE (INITIAL 900K NEXT 50K);
CREATE UNIQUE INDEX INDEX2_REPPONTO ON REPPONTO (PIS, IFUNC) tablespace ACESINDX STORAGE (INITIAL 900K NEXT 50K);


-- **********************************************  fim  **********************************************

