CREATE OR REPLACE FUNCTION sqlcon_VERI_digital_tcp7 (cMatric VARCHAR2, cTipTerm VARCHAR2,
cTempl_tit1tot IN OUT VARCHAR2, cTempl_tit2tot IN OUT VARCHAR2, 
cTempl_tit3tot IN OUT VARCHAR2, cTempl_tit4tot IN OUT VARCHAR2, 
cTempl_Alt1tot IN OUT VARCHAR2, cTempl_Alt2tot IN OUT VARCHAR2, 
cTempl_Alt3tot IN OUT VARCHAR2, cTempl_Alt4tot IN OUT VARCHAR2, 
cTempl_tit5tot IN OUT VARCHAR2, cTempl_Alt5tot IN OUT VARCHAR2, 
cNivel IN OUT VARCHAR2, mensagem OUT VARCHAR2)
RETURN NUMBER IS

RetFun    NUMBER;
Alt NUMBER;
Pad NUMBER;

reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado

BEGIN
	RetFun := 0;
	cNivel := Null;

	mensagem := 'ok';
	BEGIN
		SELECT 
		    c.Templ_Tit1, c.Templ_Tit2, c.Templ_Tit3, c.Templ_Tit4, 
		    c.Templ_Alt1, c.Templ_Alt2, c.Templ_Alt3, c.Templ_Alt4,
		    c.nivel, c.Templ_Tit5, c.Templ_Alt5
		INTO 
		    cTempl_tit1tot, cTempl_tit2tot, cTempl_tit3tot, cTempl_tit4tot, 
		    cTempl_alt1tot, cTempl_alt2tot, cTempl_alt3tot, cTempl_alt4tot,
		    cNivel, cTempl_tit5tot, cTempl_alt5tot 
		FROM CONTDIG_VERI c
		WHERE c.Icard = cMatric 
		FOR UPDATE NOWAIT;
		
	EXCEPTION
		WHEN reco_lock THEN           -- lockado
			RetFun := -3;
			mensagem := 'registro lockado!! Retorno = '|| TO_CHAR(RetFun);
			return (RetFun);
    	WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
			--RetFun := 3;
			RetFun := -2;
			mensagem := 'Digital nao encontrado !! ';
			--return (RetFun);
		WHEN OTHERS THEN              -- outros erros
			RetFun := -1;
			mensagem := 'Outros erros encontrados!! Retorno = '|| TO_CHAR(RetFun);
			return (RetFun);
	END;

	Pad := 1;    -- assume que tem template padrao
	Alt := 1;    -- assume que tem template alternativo
	if ((cTempl_tit1tot is Null) or (cTempl_tit2tot is Null) or 
		(cTempl_tit3tot is Null) or (cTempl_tit4tot is Null) or
		(cTempl_tit5tot is Null) or
		(length(cTempl_tit1tot) < 160) or (length(cTempl_tit2tot) < 160) or
		(length(cTempl_tit3tot) < 160) or (length(cTempl_tit4tot) < 160) or
		(length(cTempl_tit5tot) < 56)) then
		Pad := 0;
	end if;
	if ((cTempl_alt1tot is Null) or (cTempl_alt2tot is Null) or
		(cTempl_alt3tot is Null) or (cTempl_alt4tot is Null) or
		(cTempl_ALt5tot is Null) or
		(length(cTempl_alt1tot) < 160) or (length(cTempl_alt2tot) < 160) or
		(length(cTempl_alt3tot) < 160) or (length(cTempl_alt4tot) < 160) or
		(length(cTempl_ALt5tot) < 56)) then 
		Alt := 0;
	end if;
	if (Pad = 1) then
		if (Alt = 1) then
			Retfun := 0;   -- tem padrao e tem alternativo
		else 
			Retfun := 1;   -- tem padrao e nao tem alternativo
		end if;
	end if;
	if (Pad = 0) then
		if (Alt = 1) then
			Retfun := 2;   -- nao tem padrao e tem alternativo
		else 
			Retfun := 3;   -- nao tem padrao e nao tem alternativo
		end if;
	end if;
		
	Return (RetFun);
	
END sqlcon_VERI_digital_tcp7;
/
