CREATE or REPLACE FUNCTION sqller_comldig2
(
cEndIp in VARCHAR2,
cListaMat in out VARCHAR2
) 
RETURN NUMBER IS

xCont NUMBER;
cStatus VARCHAR2(1);
cBioTipo VARCHAR2(1);
cAux VARCHAR2(12);
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);

cursor ldig001_cur is 
	SELECT ICARD, STATUS FROM DIG001 
		WHERE END_IP = cEndIp AND STATUS != '0' AND STATUS != '2' 
		order by ICARD for update of STATUS;

cursor ldig003_cur is 
	SELECT ICARD, STATUS FROM DIG003 
		WHERE END_IP = cEndIp AND STATUS != '0' AND STATUS != '2'  
		order by ICARD for update of STATUS;

begin
    xCont := 0;
    cBioTipo := '0';

	BEGIN
		SELECT STATUS, BIO_TIPO into cStatus, cBioTipo 
		FROM DIG002 
		WHERE END_IP = cEndIp for update nowait;

		IF (cStatus = '1') then
			IF (cBioTipo = '6' OR cBioTipo = '7') then
				for r in ldig001_cur LOOP
					cListaMat := cListaMat || r.Icard;
					update DIG001 set STATUS = '2' where current of ldig001_cur ;
					xCont := xCont+1;
					if (xCont >= 90) then
						Exit;
					end if;
				END LOOP;

				IF (xCont = 0) THEN
					UPDATE DIG002 SET STATUS = '0' WHERE END_IP = cEndIp;
				ELSE
					cListaMat := cListaMat || ';';
					UPDATE DIG002 SET STATUS = '2' WHERE END_IP = cEndIp;
				END IF;

			ELSE
				for r in ldig003_cur LOOP
					cListaMat := cListaMat || r.Icard;
					update DIG003 set STATUS = '2' where current of ldig003_cur ;
					xCont := xCont+1;
					if (xCont >= 40) then
						Exit;
					end if;
				END LOOP;

				IF (xCont = 0) THEN
					UPDATE DIG002 SET STATUS = '0' WHERE END_IP = cEndIp;
				ELSE
					cListaMat := cListaMat || ';';
					UPDATE DIG002 SET STATUS = '2' WHERE END_IP = cEndIp;
				END IF;
			END IF;				
		ELSE
			COMMIT;
			return (0);
		END IF;					

	EXCEPTION
		WHEN NO_DATA_FOUND THEN
			return (0);
		WHEN reco_lock THEN
			return (0);
		WHEN OTHERS THEN
			return (0);
	END;
    
	
	COMMIT;
	return (xCont);
		
END sqller_comldig2;
/

