CREATE OR REPLACE PROCEDURE Auxtrg_digmatcod (cMatric in VARCHAR2, cEndIP in VARCHAR2) IS
cBio VARCHAR2(1);
cSt varchar2(1);
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado


BEGIN

	BEGIN
		-- verifica o tipo de biometria do equipamento codin
		SELECT BIO_TIPO INTO cBio FROM DAT07
			WHERE END_IP = cEndIP;

		IF (cBio = '6') or (cBio = '7') THEN 	-- biometria sagem
			BEGIN
				SELECT STATUS into cSt from CONTDIG_SAGEM WHERE 
					ICARD = cMatric FOR UPDATE NOWAIT;
				IF (cSt = '0') THEN
					UPDATE CONTDIG_SAGEM set STATUS = '3'  
						WHERE ICARD = cMatric ;
					COMMIT;
				END IF;
					
			EXCEPTION
				WHEN NO_DATA_FOUND THEN NULL;
				WHEN reco_lock THEN NULL;
				WHEN OTHERS THEN NULL;	
			END;
		
		ELSIF (cBio = '8') THEN				-- biometria tsi1
			BEGIN
				SELECT STATUS into cSt from CONTDIG_TSI1 WHERE 
					ICARD = cMatric FOR UPDATE NOWAIT;
				IF (cSt = '0') THEN
					UPDATE CONTDIG_TSI1 set STATUS = '3'  
						WHERE ICARD = cMatric ;
					COMMIT;
				END IF;
					
			EXCEPTION
				WHEN NO_DATA_FOUND THEN NULL;
				WHEN reco_lock THEN NULL;
				WHEN OTHERS THEN NULL;	
			END;
		END IF;

	EXCEPTION 
		WHEN NO_DATA_FOUND THEN NULL;
		WHEN OTHERS THEN NULL;
	END;

END Auxtrg_digmatcod;	
/


