CREATE OR REPLACE FUNCTION sqlat_dados_smartseg (cRegistro in VARCHAR2, cRegdh in VARCHAR2, Faixa in NUMBER, Tipo in NUMBER) 
   RETURN NUMBER IS
      NumMat VARCHAR2(12);
      VarAux VARCHAR2(12);
      IniHA DATE;
      FimHA DATE;
      IniIJ DATE;
      FimIJ DATE;
      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  
      Retorno NUMBER;

BEGIN
	NumMat := substr(cRegistro, 1, 12);
	Retorno := 0;

	IF Tipo in (1,3,5,7) THEN	-- atualiza CONTROLE   
	BEGIN
		SELECT Icard into VarAux from Controle 
		 WHERE Icard = NumMat for update nowait;

		IF (Faixa = 1) THEN
			UPDATE CONTROLE  
			SET Subnv = substr(cRegistro, 13, 5),
				Ultrs = substr(cRegistro, 18, 25),
				Qtd_Mens = substr(cRegistro, 43, 2),
				Cred_Fx1 = substr(cRegistro, 45, 2),
				Ultpas_Ref = substr(cRegistro, 47, 10),
				Situa = substr(cRegistro, 57, 1),
				Planta = substr(cRegistro, 58, 3),
				ULTRSEG = substr(cRegistro, 61, 2)
			WHERE Icard = NumMat;

		ELSIF (Faixa = 2) THEN
			UPDATE CONTROLE  
			SET Subnv = substr(cRegistro, 13, 5),
				Ultrs = substr(cRegistro, 18, 25),
				Qtd_Mens = substr(cRegistro, 43, 2),
				Cred_Fx2 = substr(cRegistro, 45, 2),
				Ultpas_Ref = substr(cRegistro, 47, 10),
				Situa = substr(cRegistro, 57, 1),
				Planta = substr(cRegistro, 58, 3),
				ULTRSEG = substr(cRegistro, 61, 2)
			WHERE Icard = NumMat;

		ELSIF (Faixa = 3) THEN
			UPDATE CONTROLE  
			SET Subnv = substr(cRegistro, 13, 5),
				Ultrs = substr(cRegistro, 18, 25),
				Qtd_Mens = substr(cRegistro, 43, 2),
				Cred_Fx3 = substr(cRegistro, 45, 2),
				Ultpas_Ref = substr(cRegistro, 47, 10),
				Situa = substr(cRegistro, 57, 1),
				Planta = substr(cRegistro, 58, 3),
				ULTRSEG = substr(cRegistro, 61, 2)
			WHERE Icard = NumMat;

		ELSIF (Faixa = 4) THEN
			UPDATE CONTROLE  
			SET Subnv = substr(cRegistro, 13, 5),
				Ultrs = substr(cRegistro, 18, 25),
				Qtd_Mens = substr(cRegistro, 43, 2),
				Cred_Fx4 = substr(cRegistro, 45, 2),
				Ultpas_Ref = substr(cRegistro, 47, 10),
				Situa = substr(cRegistro, 57, 1),
				Planta = substr(cRegistro, 58, 3),
				ULTRSEG = substr(cRegistro, 61, 2)
			WHERE Icard = NumMat;

		ELSIF (Faixa = 5) THEN
			UPDATE CONTROLE  
			SET Subnv = substr(cRegistro, 13, 5),
				Ultrs = substr(cRegistro, 18, 25),
				Qtd_Mens = substr(cRegistro, 43, 2),
				Cred_Fx5 = substr(cRegistro, 45, 2),
				Ultpas_Ref = substr(cRegistro, 47, 10),
				Situa = substr(cRegistro, 57, 1),
				Planta = substr(cRegistro, 58, 3),
				ULTRSEG = substr(cRegistro, 61, 2)
			WHERE Icard = NumMat;

		ELSIF (Faixa = 6) THEN
			UPDATE CONTROLE  
			SET Subnv = substr(cRegistro, 13, 5),
				Ultrs = substr(cRegistro, 18, 25),
				Qtd_Mens = substr(cRegistro, 43, 2),
				Cred_Fx6 = substr(cRegistro, 45, 2),
				Ultpas_Ref = substr(cRegistro, 47, 10),
				Situa = substr(cRegistro, 57, 1),
				Planta = substr(cRegistro, 58, 3),
				ULTRSEG = substr(cRegistro, 61, 2)
			WHERE Icard = NumMat;

		ELSE
			UPDATE CONTROLE  
			SET Subnv = substr(cRegistro, 13, 5),
				Ultrs = substr(cRegistro, 18, 25),
				Qtd_Mens = substr(cRegistro, 43, 2),
				Situa = substr(cRegistro, 57, 1),
				Planta = substr(cRegistro, 58, 3),
				ULTRSEG = substr(cRegistro, 61, 2)
			WHERE Icard = NumMat;
     
		END IF;
		COMMIT;

	EXCEPTION
		WHEN reco_lock THEN           -- reg. ja'lockado
			Retorno := -3;
		WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
			Retorno := -1;
		WHEN OTHERS THEN
			Retorno := -1;
	END;
	END IF;
   
	IF Tipo in (2,6) THEN	-- atualiza CONTROLE  MAS SOMENTE ULTPASREF E CREDITOS
	BEGIN
		SELECT Icard into VarAux from Controle 
			WHERE Icard = NumMat for update nowait;

		IF (Faixa = 1) THEN
			UPDATE CONTROLE  
			SET Cred_Fx1 = substr(cRegistro, 45, 2),
				Ultpas_Ref = substr(cRegistro, 47, 10)
			WHERE Icard = NumMat;

		ELSIF (Faixa = 2) THEN
			UPDATE CONTROLE  
			SET Cred_Fx2 = substr(cRegistro, 45, 2),
				Ultpas_Ref = substr(cRegistro, 47, 10)
			WHERE Icard = NumMat;

		ELSIF (Faixa = 3) THEN
			UPDATE CONTROLE  
			SET Cred_Fx3 = substr(cRegistro, 45, 2),
				Ultpas_Ref = substr(cRegistro, 47, 10)
			WHERE Icard = NumMat;

		ELSIF (Faixa = 4) THEN
			UPDATE CONTROLE  
			SET Cred_Fx4 = substr(cRegistro, 45, 2),
				Ultpas_Ref = substr(cRegistro, 47, 10)
			WHERE Icard = NumMat;

		ELSIF (Faixa = 5) THEN
			UPDATE CONTROLE  
			SET Cred_Fx5 = substr(cRegistro, 45, 2),
				Ultpas_Ref = substr(cRegistro, 47, 10)
			WHERE Icard = NumMat;

		ELSIF (Faixa = 6) THEN
			UPDATE CONTROLE  
			SET Cred_Fx6 = substr(cRegistro, 45, 2),
				Ultpas_Ref = substr(cRegistro, 47, 10)
			WHERE Icard = NumMat;

		END IF;
		COMMIT;

	EXCEPTION
		WHEN reco_lock THEN           -- reg. ja'lockado
			Retorno := -3;
		WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
			Retorno := -1;
		WHEN OTHERS THEN
			Retorno := -1;
	END;
	END IF;

	IF Tipo in (4,5,6,7) THEN	-- atualiza DATAHORA
		IniHA := TO_DATE (substr(cRegdh, 13, 12), 'DDMMYYHH24MISS');
		FimHA := TO_DATE (substr(cRegdh, 25, 12), 'DDMMYYHH24MISS');
		IniIJ := TO_DATE (substr(cRegdh, 37, 12), 'DDMMYYHH24MISS');
		FimIJ := TO_DATE (substr(cRegdh, 49, 12), 'DDMMYYHH24MISS');

	BEGIN
		SELECT Icard into VarAux from DATAHORA
		WHERE Icard = NumMat for update nowait;
		 
		UPDATE DATAHORA 
		SET Ini_Halm = IniHA,
			Fim_Halm = FimHA,
			Ini_Intj = IniIJ,
			Fim_Intj = FimIJ
   	 	WHERE Icard = NumMat;
		COMMIT;
   
	EXCEPTION
		WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
			INSERT INTO DATAHORA (Icard, Ini_Halm, Fim_Halm, Ini_Intj, Fim_Intj) 
         				  values (NumMat, IniHA, FimHA, IniIJ, FimIJ);
			COMMIT;
		WHEN OTHERS THEN
			Retorno := -1;
	END;
	END IF;
   
	RETURN (Retorno);
END sqlat_dados_smartseg;
/


