CREATE OR REPLACE FUNCTION sqlalarme_codin_tcp (pt_alarme in VARCHAR2, mensagem OUT VARCHAR2)
   RETURN NUMBER IS
   nRetSem NUMBER;
   cEndIp VARCHAR2(15);
   cAlarm VARCHAR2(2);
   cStat  VARCHAR2(1);
   cTerm  VARCHAR2(2);
   cMens  VARCHAR2(22);
   cAux   VARCHAR2(1);
   reco_lock EXCEPTION;
   PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado 

BEGIN
   cEndIp := SUBSTR(pt_alarme, 1,15);
   cAlarm := SUBSTR(pt_alarme, 16,2);
   cStat  := SUBSTR(pt_alarme, 18,1);
   cMens  := SUBSTR(pt_alarme, 19,15);

   mensagem := cEndIp || cAlarm || cStat || cMens;
   INSERT INTO TABALARME (END_IP, ALARME, STATUS, INFORM) 
	VALUES (cEndIp, cAlarm, cStat, cMens);          
   COMMIT;     

   return (0);
END sqlalarme_codin_tcp;
/



