CREATE OR REPLACE FUNCTION sqlavisa_cpbb_novell (pt_aviso in VARCHAR2)
   RETURN NUMBER IS
   nRetSem NUMBER;
   cBlueB VARCHAR2(2);
   cAviso VARCHAR2(2);
   cStat  VARCHAR2(1);
   cTerm  VARCHAR2(2);
   cMens  VARCHAR2(30);
   cAux   VARCHAR2(1);
   reco_lock EXCEPTION;
   PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado 

BEGIN
   nRetSem := 1;
   cBlueB := SUBSTR(pt_aviso, 1,2);
   cAviso := SUBSTR(pt_aviso, 3,2);
   cStat  := SUBSTR(pt_aviso, 5,1);
   cTerm  := SUBSTR(pt_aviso, 6,2);
   cMens  := SUBSTR(pt_aviso, 8,30);

   BEGIN
      SELECT St INTO cAux FROM cp_bn 
	WHERE Aviso = cAviso AND
              BlueB = cBlueB AND
	      Term  = cTerm;
      SELECT St INTO cAux FROM cp_bn 
	WHERE Aviso = cAviso AND
              BlueB = cBlueB AND
	      Term  = cTerm
	FOR UPDATE NOWAIT; 
   EXCEPTION
      WHEN reco_lock THEN nRetSem := -1;
      WHEN NO_DATA_FOUND THEN nRetSem := 0;
   END;

   IF (nRetSem = 1) THEN            -- aviso existe, substitui aviso 
      UPDATE cp_bn SET St = cStat, 
		     Epn3 = cMens 
	WHERE Aviso = cAviso AND
              BlueB = cBlueB AND
	      Term  = cTerm;

      -- atualiza semaforo e efetiva transacao 
      UPDATE sbbe SET sinal = '1';
      COMMIT;        

   ELSIF (nRetSem = 0) THEN       
      -- aviso nao existe, sera' inserido novo comando
      INSERT INTO cp_bn (BLUEB, AVISO, ST, TERM, EPN3) VALUES (cBlueB, cAviso, cStat, cTerm, cMens);          

      -- atualiza semaforo e efetiva transacao 
      UPDATE sbbe SET sinal = '1';
      COMMIT;     

   END IF; 
   return (nRetSem);
END sqlavisa_cpbb_novell;
/



CREATE OR REPLACE FUNCTION sqlav_novell2 (mensagem OUT VARCHAR2)
   RETURN NUMBER IS
      r   NUMBER;
      Ret NUMBER;
      Seq NUMBER;

BEGIN

   Ret := 0;
   SELECT Sequencia INTO Seq from SBBE;

   -- tenta unlockar o semaforo 
   r := sys.dbms_lock.release (Seq);
   IF (r = 0) THEN
      mensagem := 'Semaforo SBBE Liberado!!!';
      Ret := 0;
   ELSE
      mensagem := 'Erro, Liberando Registro';
      Ret := -1;
   END IF;

   return (Ret);
END sqlav_novell2;
/

