CREATE OR REPLACE FUNCTION sqlcon_sagem_digital4 (cMatric VARCHAR2, cTipTerm VARCHAR2, 
cTempl_tit1tot IN OUT VARCHAR2, cTempl_tit2tot IN OUT VARCHAR2, 
cTempl_tit3tot IN OUT VARCHAR2, cTempl_tit4tot IN OUT VARCHAR2, 
cTempl_Alt1tot IN OUT VARCHAR2, cTempl_Alt2tot IN OUT VARCHAR2, 
cTempl_Alt3tot IN OUT VARCHAR2, cTempl_Alt4tot IN OUT VARCHAR2, 
cTempl_tit5tot IN OUT VARCHAR2, cTempl_Alt5tot IN OUT VARCHAR2, 
cTempl_tit6tot IN OUT VARCHAR2, cTempl_Alt6tot IN OUT VARCHAR2, 
cNivel IN OUT VARCHAR2, mensagem OUT VARCHAR2) 
RETURN NUMBER IS

RetFun    NUMBER;
Alt NUMBER;
Pad NUMBER;
cTempl_tit4Aux VARCHAR2(32);
cTempl_alt4Aux VARCHAR2(32);
cVDigit    VARCHAR2(1);	

reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado

BEGIN
	RetFun := 0;
	cNivel := Null;
	Pad := 0;
	Alt := 0;
	mensagem := 'ok';
	cVDigit := '2';		-- 1
	
	BEGIN
		SELECT 
			c.Templ_Tit1, c.Templ_Tit2, c.Templ_Tit3, c.Templ_Tit4, 
			c.Templ_Alt1, c.Templ_Alt2, c.Templ_Alt3, c.Templ_Alt4,
			c.nivel,
			a.Ver_Digit
		INTO 
			cTempl_tit1tot, cTempl_tit2tot, cTempl_tit3tot, cTempl_tit4Aux, 
			cTempl_alt1tot, cTempl_alt2tot, cTempl_alt3tot, cTempl_alt4Aux,  
			cNivel,
			cVDigit
		FROM CONTDIG_SAGEM c, CONTROLE a
		WHERE c.Icard = cMatric and
			  a.Icard = cMatric
		FOR UPDATE NOWAIT;
			
		Pad := 1;    -- assume que tem template padrao
		Alt := 1;    -- assume que tem template alternativo
		if ((cTempl_tit1tot is Null) or (cTempl_tit2tot is Null) or 
			(cTempl_tit3tot is Null) or (cTempl_tit4Aux is Null) OR
			(length(cTempl_tit1tot) < 160) or (length(cTempl_tit2tot) < 160) or
			(length(cTempl_tit3tot) < 160) or (length(cTempl_tit4Aux) < 32)) then
			Pad := 0;
		end if;

		if (length(cTempl_tit4Aux) = 32) then
			cTempl_tit4tot := RPAD(cTempl_tit4Aux, 160, '0');
			cTempl_tit5tot := RPAD('0', 160, '0');
			cTempl_tit6tot := RPAD('0', 26, '0');
		end if;

		if ((cTempl_alt1tot is Null) or (cTempl_alt2tot is Null) or
			(cTempl_alt3tot is Null) or (cTempl_alt4Aux is Null) or
			(length(cTempl_alt1tot) < 160) or (length(cTempl_alt2tot) < 160) or
			(length(cTempl_alt3tot) < 160) or (length(cTempl_alt4Aux) < 32)) then 
			Alt := 0;
		end if;

		if (length(cTempl_alt4Aux) = 32) then
			cTempl_alt4tot := RPAD(cTempl_alt4Aux, 160, '0');
			cTempl_alt5tot := RPAD('0', 160, '0');
			cTempl_alt6tot := RPAD('0', 26, '0');
		end if;
		if (cVDigit is Null) then
			cVDigit := '2';		-- 1
        end if;
		
			
	EXCEPTION
		WHEN reco_lock THEN           -- lockado
			RetFun := -3;
			mensagem := 'registro lockado!! Retorno = '|| TO_CHAR(RetFun);
			return (RetFun);
		WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
			--RetFun := 3;
			IF (to_number(cVDigit) = 2) THEN
				RetFun := -2;
				mensagem := 'Digital nao encontrado !! ';
			ELSE
				Pad := 0;
				Alt := 0;
			END IF;				
			--	return (RetFun);
		WHEN OTHERS THEN              -- outros erros
			RetFun := -1;
			mensagem := 'Outros erros encontrados!! Retorno = '|| TO_CHAR(RetFun);
			return (RetFun);
	END;
		
	if (Pad = 1) then
	    if (Alt = 1) then
			Retfun := 0;   -- tem padrao e tem alternativo
		else 
			Retfun := 1;   -- tem padrao e nao tem alternativo
    	end if;
	end if;

	if (Pad = 0) then
	    if (Alt = 1) then
			Retfun := 2;   -- nao tem padrao e tem alternativo
		else 
			Retfun := 3;   -- nao tem padrao e nao tem alternativo
    	end if;
	end if;
	--cRegistro := cRegistro || cNivel;   -- atualiza nivel
		
	COMMIT;
	Return (RetFun);

END sqlcon_sagem_digital4;
/
