CREATE OR REPLACE FUNCTION sqlat_tab_acessoSeg (cRegistro in VARCHAR2, Posic in VARCHAR2) 
   RETURN NUMBER IS
      NumMat VARCHAR2(12);
      VarAux VARCHAR2(12);
      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  
      Retorno NUMBER;
BEGIN
      Retorno := 0;      
      NumMat := substr(cRegistro, 1, 12);

   BEGIN
      SELECT Icard into VarAux from Controle 
		 WHERE rowid = chartorowid (Posic) for update nowait;

      UPDATE controle 
	 SET Situa = substr(cRegistro, 13, 1),
	     Subnv = substr(cRegistro, 14, 5),
	     Ultrs = substr(cRegistro, 19, 25),
	     Fx_Dta = substr(cRegistro, 44, 11),
	     Qtd_Mens = substr(cRegistro, 55, 2),
	     Cred_Fx1 = substr(cRegistro, 57, 2),
	     Cred_Fx2 = substr(cRegistro, 59, 2),
	     Cred_Fx3 = substr(cRegistro, 61, 2),
	     Cred_Fx4 = substr(cRegistro, 63, 2),
	     Cred_Fx5 = substr(cRegistro, 65, 2),
	     Cred_Fx6 = substr(cRegistro, 67, 2),
	     UltPas_Ref = substr(cRegistro, 69, 10),
         Planta = substr(cRegistro, 79, 3),
		 ULTRSEG = substr(cRegistro, 82, 2)


--	 SET Situa = substr(cRegistro, 23, 1),
--	     Subnv = substr(cRegistro, 24, 5),
--	     Ultrs = substr(cRegistro, 235, 25),
--	     Fx_Dta = substr(cRegistro, 261, 11),
--	     Qtd_Mens = substr(cRegistro, 353, 2),
--	     Cred_Fx1 = substr(cRegistro, 355, 2),
--	     Cred_Fx2 = substr(cRegistro, 361, 2),
--	     Cred_Fx3 = substr(cRegistro, 367, 2),
--	     Cred_Fx4 = substr(cRegistro, 373, 2),
--	     Cred_Fx5 = substr(cRegistro, 379, 2),
--	     Cred_Fx6 = substr(cRegistro, 385, 2)

	 WHERE rowid = chartorowid (Posic);

      COMMIT;

   EXCEPTION
      WHEN reco_lock THEN           -- reg. ja'lockado
	 Retorno := -3;
      WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
	 Retorno := -1;
      WHEN OTHERS THEN
	 Retorno := -1;
   END;
   return (Retorno);
END sqlat_tab_acessoSeg;
/


