CREATE OR REPLACE FUNCTION sqlat_tab_acesso_intjseg (cRegistro in VARCHAR2, Posic in VARCHAR2, cReg_dthora in VARCHAR2) 
   RETURN NUMBER IS
      NumMat VARCHAR2(12);
      VarAux VARCHAR2(12);
      IniHA DATE;
      FimHA DATE;
      IniIJ DATE;
      FimIJ DATE;
      HorAntD DATE;
      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  
      Retorno NUMBER;
BEGIN
	Retorno := 0;      
	NumMat := substr(cRegistro, 1, 12);
	IniHA := TO_DATE (substr(cReg_dthora, 1, 12), 'DDMMRRHH24MISS');
	FimHA := TO_DATE (substr(cReg_dthora, 13, 12), 'DDMMRRHH24MISS');
	IniIJ := TO_DATE (substr(cReg_dthora, 25, 12), 'DDMMRRHH24MISS');
	FimIJ := TO_DATE (substr(cReg_dthora, 37, 12), 'DDMMRRHH24MISS');
	HorAntD := TO_DATE (substr(cReg_dthora, 49, 12), 'DDMMRRHH24MISS');
	
	-- atualiza tab.CONTROLE
	BEGIN
		SELECT Icard into VarAux from Controle 
			WHERE rowid = chartorowid (Posic) for update nowait;

		UPDATE controle 
			SET Situa = substr(cRegistro, 13, 1),
				Subnv = substr(cRegistro, 14, 5),
				Ultrs = substr(cRegistro, 19, 25),
				Fx_Dta = substr(cRegistro, 44, 11),
				Qtd_Mens = substr(cRegistro, 55, 2),
				Cred_Fx1 = substr(cRegistro, 57, 2),
				Cred_Fx2 = substr(cRegistro, 59, 2),
				Cred_Fx3 = substr(cRegistro, 61, 2),
				Cred_Fx4 = substr(cRegistro, 63, 2),
				Cred_Fx5 = substr(cRegistro, 65, 2),
				Cred_Fx6 = substr(cRegistro, 67, 2),
				UltPas_Ref = substr(cRegistro, 69, 10),
				Planta = substr(cRegistro, 79, 3),
				ULTRSEG = substr(cRegistro, 82, 2)
		WHERE rowid = chartorowid (Posic);
		COMMIT;
	
	EXCEPTION
		WHEN reco_lock THEN           -- reg. ja'lockado
			Retorno := -3;
		WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
			Retorno := -1;
		WHEN OTHERS THEN
			Retorno := -1;
	END;
 
	-- atualiza tab.DATAHORA
	BEGIN
		SELECT Icard into VarAux from DATAHORA 
			WHERE Icard = NumMat for update nowait;
   
		UPDATE DATAHORA 
			SET Ini_Halm = IniHA,
				Fim_Halm = FimHA,
				Ini_Intj = IniIJ,
				Fim_Intj = FimIJ,
				Fim_AntiD = HorAntD 
   	 	WHERE Icard = NumMat;
		COMMIT;
   
	EXCEPTION
		WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
			INSERT INTO DATAHORA (Icard, Ini_Halm, Fim_Halm, Ini_Intj, Fim_Intj, Fim_AntiD) 
         				  values (NumMat, IniHA, FimHA, IniIJ, FimIJ, HorAntD);
			COMMIT;
		WHEN OTHERS THEN
			Retorno := -1;
	END;
	return (Retorno);
END sqlat_tab_acesso_intjseg;
/


