CREATE OR REPLACE FUNCTION SQLATU_GEOMOK_CNX (cMatric in VARCHAR2, nChave in NUMBER, templ1 in VARCHAR2, templ2 in VARCHAR2, 
templ3 in VARCHAR2, templ4 in VARCHAR2, nTipo in NUMBER, cNumDedo in VARCHAR2, cNivel in VARCHAR2, templ5 in VARCHAR2,
templ6 in VARCHAR2)
   RETURN NUMBER IS
   cAuxMat VARCHAR2(15);
   matric VARCHAR2(15);
   nRetorno NUMBER;
   cAux   VARCHAR2(1);
   cGrupo VARCHAR2(2);
   reco_lock EXCEPTION;
   PRAGMA EXCEPTION_INIT (reco_lock,-54);  -- erro quando registro lockado 

BEGIN
	nRetorno := 1;
	matric := cMatric;

	IF (nChave = 1)	 then 	-- pesquisa por Numero Serial, para coletar valor de Icard
	    
		BEGIN
			SELECT ICARD 
				into matric
			FROM Controle A
			WHERE A.NumSerial = substr(cMatric, 3, 10);
		EXCEPTION
			WHEN NO_DATA_FOUND THEN matric := cMatric;
			WHEN OTHERS THEN matric := cMatric;
		END;
	ELSIF (nChave = 2)	 then 	-- pesquisa por CPF, para coletar valor de Icard
		BEGIN
			SELECT ICARD 
				into matric
			FROM ContCPF A 
			WHERE  A.CPF = substr(cMatric, 2, 11); 
		EXCEPTION
			WHEN NO_DATA_FOUND THEN matric := cMatric;
			WHEN OTHERS THEN matric := cMatric;
		END;
	END IF;		

	BEGIN
		SELECT Icard INTO cAuxMat FROM CONTDIG_OMOK
		WHERE Icard = matric 
		FOR UPDATE NOWAIT;
	EXCEPTION
		WHEN reco_lock THEN nRetorno:= -1;
		WHEN NO_DATA_FOUND THEN nRetorno := 0;
		WHEN OTHERS THEN nRetorno := -1;
	END;
	cGrupo := '0'|| substr(templ1,19,1);	
	IF (nRetorno = 1) THEN          -- matricula existe, substitui digital
		IF (nTipo = 0) THEN          -- template padrao (0)
			UPDATE ContDig_OMOK
			SET Templ_Tit1 = templ1,
				Templ_Tit2 = templ2,
				Templ_Tit3 = templ3,
				Templ_Tit4 = templ4,
				Templ_Tit5 = templ5,
				Templ_Tit6 = templ6,
				Nivel = cNivel,
				Num_Dedo_Pad = cNumDedo,
				St_Pad = '1',
				Grupo_tit = cGrupo
			WHERE Icard = matric;
		ELSIF (nTipo = 1) THEN          -- template alternativo (1)
			UPDATE ContDig_OMOK
			SET Templ_Alt1 = templ1,
				Templ_Alt2 = templ2,
				Templ_Alt3 = templ3,
				Templ_Alt4 = templ4,
				Templ_Alt5 = templ5,
				Templ_Alt6 = templ6,
				Nivel = cNivel,
				Num_Dedo_Alt = cNumDedo,
				St_Alt = '1',
				Grupo_Alt = cGrupo
			WHERE Icard = matric;
		ELSIF (nTipo = 2) THEN			-- template de coao (2)
			UPDATE ContDig_OMOK
			SET Templ_Coa1 = templ1,
				Templ_Coa2 = templ2,
				Templ_Coa3 = templ3,
				Templ_Coa4 = templ4,
				Templ_Coa5 = templ5,
				Templ_Coa6 = templ6,
				Nivel = cNivel,
				Num_Dedo_Coa = cNumDedo,
				St_Coa = '1'
			WHERE Icard = matric;
		END IF;
	ELSIF (nRetorno = 0) THEN       
		-- matrcula nao existe, sera' inserido novo 
		IF (nTipo = 0) THEN          -- template padrao (0)
			INSERT INTO ContDig_OMOK (Icard, Templ_tit1, Templ_tit2, Templ_tit3, Templ_tit4, 
				Templ_tit5, Templ_tit6, Nivel, Num_dedo_Pad, St_Pad, Grupo_Tit)			   
			VALUES (matric, templ1, templ2, templ3, templ4, Templ5, Templ6, cNivel, cNumDedo, '1', cGrupo);
		ELSIF (nTipo = 1) THEN
			INSERT INTO ContDig_OMOK (Icard, Templ_Alt1, Templ_Alt2, Templ_Alt3, Templ_Alt4,
				Templ_Alt5, Templ_Alt6, Nivel, Num_dedo_Alt, St_Alt, Grupo_Alt)  
			VALUES (matric, templ1, templ2, templ3, templ4, Templ5, Templ6, cNivel, cNumDedo, '1', cGrupo);
		ELSIF (nTipo = 2) THEN
			INSERT INTO ContDig_OMOK (Icard, Templ_Coa1, Templ_Coa2, Templ_Coa3, Templ_Coa4,
				Templ_Coa5, Templ_Coa6, Nivel, Num_dedo_Coa, St_Coa)  
			VALUES (matric, templ1, templ2, templ3, templ4, Templ5, Templ6, cNivel, cNumDedo, '1');
		END IF;
	END IF;
	COMMIT;     
	return (nRetorno);
END SQLATU_GEOMOK_CNX;
/

