CREATE OR REPLACE FUNCTION request_lock (cMatric VARCHAR2, cUsuario VARCHAR2)
RETURN NUMBER IS

ret NUMBER;
dh_lock DATE;
difminuto NUMBER;
cUsulock VARCHAR2(15);

reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado

BEGIN
	ret := 0;
	
	BEGIN
		-- locka matricula se esta nao estiver lockada
		select DATAHORA, USUARIO into dh_lock, cUsuLock from TABLOCKS where ICARD = cMatric for update nowait;
		
		IF (((sysdate-dh_lock)*24*60*60 ) >= 60) then 
			-- modifica data e hora do lock
			update TABLOCKS set DATAHORA = SYSDATE, USUARIO = cUsuario 
			    where ICARD = cMatric;
			 
		ELSIF (cUsuLock != cUsuario) then
				ret := -1;
		END IF;
		
	EXCEPTION 		
		WHEN NO_DATA_FOUND then       -- reg. nao encontrado
			insert into TABLOCKS (ICARD, DATAHORA, USUARIO) values (cMatric, SYSDATE, cUsuario);

		WHEN reco_lock THEN           -- lockado
			ret := 0;

		WHEN OTHERS then
			ret := 0;
	END;

	COMMIT;
	return (ret);
END request_lock;
/
