CREATE OR REPLACE  PROCEDURE PREP2_SAGEM 
IS

TYPE icard_type IS TABLE OF CONTDIG_SAGEM.icard%TYPE 
	INDEX BY binary_integer;
TYPE status_type IS TABLE OF CONTDIG_SAGEM.status%TYPE 
	INDEX BY binary_integer;
	
l_icard icard_type;
l_status status_type;

total number;
aux_icard char(12) := '000000000000';
nCont number;
	
BEGIN

	SELECT ICARD, STATUS 
		BULK COLLECT INTO l_icard, l_status  
	from 
		CONTDIG_SAGEM 
	where 
		STATUS = '1' or STATUS = '2' or STATUS = '3';
		
	total := l_icard.count;
	
	FOR indx IN 1 .. total     
	LOOP
		if (l_status(indx) = '2') then
			-- apaga os icards que mudou de grupo de DIG001
			DELETE FROM DIG001 WHERE ICARD = l_icard(indx);
		END IF;		

		nCont := 0;
		
		-- MONTA temporaria matricula com codins com permissao acesso
		
		IF ((l_status(indx) = '1') or (l_status(indx) = '2')) then	-- alteracao na digital ou no grupo
			insert into TMP_DIG001 (ICARD, END_IP, STATUS, BIO_TIPO)
				select distinct l_icard(indx),  dat07.end_ip, '0', dat07.bio_tipo
					from
					  dat07, dat08, matcodin 
					where
					  (dat07.end_ip <> '000.000.000.000' and
					   dat08.grupo in (
								select grupo from CONTROLE where ICARD = l_icard(indx)
								  union
								select grupo1 from CONTROLE where ICARD = l_icard(indx)
								  union	
								select grupo2 from CONTROLE where ICARD = l_icard(indx)
								  union
								select grupo3 from CONTROLE where ICARD = l_icard(indx)
								  union
								select grupo_sab from CONTROLE where ICARD = l_icard(indx)
								  union
								select grupo_dom from CONTROLE where ICARD = l_icard(indx)
								  union
								select grupo_fer from CONTROLE where ICARD = l_icard(indx)
					  		) AND 
					   dat07.laces = dat08.laces and
					   dat07.planta = dat08.planta and
					   (dat07.bio_tipo = '6' or dat07.bio_tipo = '7') ) 
						or
					  (matcodin.icard = l_icard(indx) and
					   matcodin.end_ip <> '000.000.000.000' and 
					   matcodin.end_ip = dat07.end_ip and 
					   (dat07.bio_tipo = '6' or dat07.bio_tipo = '7') );
					   
		ELSE		-- (l_status(indx) = '3')  alteracao somente na matcodin
			insert into TMP_DIG001 (ICARD, END_IP, STATUS, BIO_TIPO)
				select distinct l_icard(indx),  matcodin.end_ip, '0', dat07.bio_tipo 
				  from
					matcodin , dat07
				  where 
					matcodin.icard = l_icard(indx) and 
					matcodin.end_ip <> '000.000.000.000' and
					matcodin.end_ip = dat07.end_ip and 
					(dat07.bio_tipo = '6' or dat07.bio_tipo = '7');
		END IF;

					   

		select count(*) into nCont from TMP_DIG001;
		if (nCont != 0) then
			-- coloca o codin na tab. DIG002 (CARGA LISTA) o codin no existir
			insert into DIG002 (END_IP, DATA_LOAD, STATUS, BIO_TIPO)
				select distinct end_ip, sysdate(), '0', bio_tipo  
				from
					tmp_dig001
				where
					end_ip not in ( select end_ip from DIG002 );

			for x in (select ICARD, END_IP, STATUS, BIO_TIPO from TMP_DIG001) loop
				BEGIN
					select icard into aux_icard from DIG001 
						WHERE ICARD = x.icard AND
							END_IP = x.end_ip for update nowait;

					UPDATE DIG001 SET STATUS = '1' 
						WHERE  ICARD = x.icard AND
							   END_IP = x.end_ip;
				EXCEPTION
					WHEN NO_DATA_FOUND THEN
						INSERT INTO DIG001 (ICARD, END_IP, STATUS, BIO_TIPO) 
						values (x.icard, x.end_ip, '1', x.bio_tipo);
				END;
			end loop;

			-- atualiza status da matricula, como tratado
			update CONTDIG_SAGEM SET STATUS = '0' 
				where ICARD = l_icard(indx);

			COMMIT;	
		end if;

	END LOOP;
	
end PREP2_SAGEM;
/
