
-- tabela DAM99
CREATE TABLE DAM99 (
  ICARD		CHAR(12)	NOT NULL,
  NUMSERIAL	CHAR(10)	NOT NULL,
  DOCUMENTO	CHAR(14)	NOT NULL,
  DOC_TIPO	CHAR(1)	NOT NULL,
  PLACA		CHAR(10),
  DIAM		CHAR(2)	NOT NULL,
  MESM		CHAR(2)	NOT NULL,
  ANOM		CHAR(2)	NOT NULL,
  HORAM		CHAR(4)	NOT NULL,
  SEGUNDO	CHAR(2)	NOT NULL,
  CODAC		CHAR(2)	NOT NULL,
  POSIC		CHAR(1)	NOT NULL,
  BLUEB		CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT		CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC	CHAR(2)	NOT NULL,
  VEICULO	VARCHAR2(15),
  ONOFF		CHAR(1))
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 15M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


-- *******************************************************
-- tabela BDCC_CRACHA
CREATE TABLE BDCC_CRACHA (
	CRACHA 		varchar(12) NOT NULL,
    BLOQUEADO 	NUMBER (1,0) NOT NULL CONSTRAINT tp_bloq1 CHECK (BLOQUEADO IN (0,1)))		-- 0= no bloqueado, 1= bloqueado
PCTFREE 20 PCTUSED 60 INITRANS 50 MAXTRANS 255 
STORAGE (INITIAL 15M NEXT 10M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0 );


CREATE UNIQUE INDEX INDEX1_BDCC_CRACHA ON BDCC_CRACHA (CRACHA) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);

-- *******************************************************

ALTER TABLE CONTCPF ADD (
	REAL CHAR(11), 
	TIPODOC CHAR(1) DEFAULT '2');

CREATE UNIQUE INDEX INDEX2_CONTCPF ON CONTCPF (ICARD) TABLESPACE ACESINDX STORAGE (INITIAL 100K NEXT 10K);

-- *******************************************************

ALTER TABLE DAM00 ADD (
	TIPODOC CHAR(2) DEFAULT '00');

-- *******************************************************

ALTER TABLE DAM01 ADD (
	TIPODOC CHAR(2) DEFAULT '00');

-- *******************************************************

ALTER TABLE DAM02 ADD (
	TIPODOC CHAR(2) DEFAULT '00');

-- *******************************************************

ALTER TABLE DAM03 ADD (
	TIPODOC CHAR(2) DEFAULT '00');
