CREATE OR REPLACE FUNCTION sqlatu_VERI_digital2 (cMatric in VARCHAR2, nChave in NUMBER, templ1 in VARCHAR2, templ2 in VARCHAR2, 
templ3 in VARCHAR2, templ4 in VARCHAR2, nTipo in NUMBER, cNumDedo in VARCHAR2, cNivel in VARCHAR2, templ5 in VARCHAR2)
   RETURN NUMBER IS
   cAuxMat VARCHAR2(15);
   matric VARCHAR2(15);
   nRetorno NUMBER;
   cAux   VARCHAR2(1);
   reco_lock EXCEPTION;
   PRAGMA EXCEPTION_INIT (reco_lock,-54);  -- erro quando registro lockado 

BEGIN
   nRetorno := 1;

	matric := cMatric;

	IF (nChave = 1)	 then 	-- pesquisa por Numero Serial, para coletar valor de Icard
	    
		BEGIN
			SELECT ICARD 
				into matric
			FROM Controle A
			WHERE A.NumSerial = substr(cMatric, 3, 10);
		EXCEPTION
			WHEN NO_DATA_FOUND THEN matric := cMatric;
			WHEN OTHERS THEN matric := cMatric;
		END;
	ELSIF (nChave = 2)	 then 	-- pesquisa por CPF, para coletar valor de Icard
		BEGIN
			SELECT ICARD 
				into matric
			FROM ContCPF A 
			WHERE  A.CPF = substr(cMatric, 2, 11); 
		EXCEPTION
			WHEN NO_DATA_FOUND THEN matric := cMatric;
			WHEN OTHERS THEN matric := cMatric;
		END;
	END IF;		

   BEGIN
      SELECT Icard INTO cAuxMat FROM CONTDIG_VERI
	WHERE Icard = matric;

      SELECT Icard INTO cAuxMat FROM CONTDIG_VERI
	WHERE Icard = matric 
	FOR UPDATE NOWAIT;

   EXCEPTION
      WHEN reco_lock THEN nRetorno:= -1;
      WHEN NO_DATA_FOUND THEN nRetorno := 0;
      WHEN OTHERS THEN nRetorno := -1;
   END;

   IF (nRetorno = 1) THEN          -- matricula existe, substitui digital
      IF (nTipo = 0) THEN          -- template padrao (0)
	UPDATE ContDig_VERI
	SET Templ_Tit1 = templ1,
	    Templ_Tit2 = templ2,
	    Templ_Tit3 = templ3,
	    Templ_Tit4 = templ4,
	    Nivel = cNivel,
	    Num_Dedo_Pad = cNumDedo,
	    Templ_Tit5 = templ5
	WHERE Icard = matric;

      ELSE                        -- template alternativo (1)
	UPDATE ContDig_VERI
	SET Templ_Alt1 = templ1,
	    Templ_Alt2 = templ2,
	    Templ_Alt3 = templ3,
	    Templ_Alt4 = templ4,
	    Nivel = cNivel,
	    Num_Dedo_Alt = cNumDedo,
	    Templ_Alt5 = templ5
	WHERE Icard = matric;
      END IF;

   ELSIF (nRetorno = 0) THEN       
      -- matrcula nao existe, sera' inserido novo 
      IF (nTipo = 0) THEN          -- template padrao (0)
         INSERT INTO ContDig_VERI (Icard, Templ_tit1, Templ_tit2, Templ_tit3, Templ_tit4,
			      Nivel, Num_dedo_Pad, Templ_tit5)			   
	 VALUES (matric, templ1, templ2, templ3, templ4, cNivel, cNumDedo,
                 Templ5);
      ELSE
         INSERT INTO ContDig_VERI (Icard, Templ_Alt1, Templ_Alt2, Templ_Alt3, Templ_Alt4,
	      Nivel, Num_dedo_Alt, Templ_Alt5)			   
	 VALUES (matric, templ1, templ2, templ3, templ4, cNivel, cNumDedo,
                 Templ5);
      END IF;
   END IF;
  
   COMMIT;     
   return (nRetorno);
END sqlatu_VERI_digital2;
/

