CREATE OR REPLACE FUNCTION sagem_ins_digital (matric in VARCHAR2, nTipo in NUMBER, templPad in VARCHAR2, 
templAlt in VARCHAR2, templCoa in VARCHAR2)
   RETURN NUMBER IS
   cAuxMat VARCHAR2(15);
   nRetorno NUMBER;
   cAux   VARCHAR2(1);
   reco_lock EXCEPTION;
   PRAGMA EXCEPTION_INIT (reco_lock,-54);  -- erro quando registro lockado 

BEGIN
	nRetorno := 1;
	BEGIN 
		SELECT Icard INTO cAuxMat FROM CONTROLE
			WHERE Icard = matric ;
	EXCEPTION
		WHEN NO_DATA_FOUND THEN 
			nRetorno := 0;
			return (nRetorno);
		WHEN OTHERS THEN 
			nRetorno := -1;
			return (nRetorno);
	END;
	
	BEGIN
		SELECT Icard INTO cAuxMat FROM CONTDIG_SAGEM
		WHERE Icard = matric 
		FOR UPDATE NOWAIT;
	EXCEPTION
		WHEN reco_lock THEN nRetorno:= -1;
		WHEN NO_DATA_FOUND THEN nRetorno := 0;
		WHEN OTHERS THEN nRetorno := -1;
	END;
	IF (nRetorno = 1) THEN          -- matricula existe, substitui digital
		IF (nTipo = 0) THEN          -- template todos (0)
			UPDATE CONTDIG_SAGEM
			SET Templ_Tit1 = substr(templPad,   1, 160),
				Templ_Tit2 = substr(templPad, 161, 160),
				Templ_Tit3 = substr(templPad, 321, 160),
				Templ_Tit4 = substr(templPad, 481,  32),
			    Templ_Alt1 = substr(templAlt,   1, 160),
				Templ_Alt2 = substr(templAlt, 161, 160),
				Templ_Alt3 = substr(templAlt, 321, 160),
				Templ_Alt4 = substr(templAlt, 481,  32),
			    Templ_Coa1 = substr(templCoa,   1, 160),
				Templ_Coa2 = substr(templCoa, 161, 160),
				Templ_Coa3 = substr(templCoa, 321, 160),
				Templ_Coa4 = substr(templCoa, 481,  32),
				Status = '1'
			WHERE Icard = matric;
		ELSIF (nTipo = 1) THEN          -- template Padrao (1)
			UPDATE CONTDIG_SAGEM
			SET Templ_Tit1 = substr(templPad,   1, 160),
				Templ_Tit2 = substr(templPad, 161, 160),
				Templ_Tit3 = substr(templPad, 321, 160),
				Templ_Tit4 = substr(templPad, 481,  32),
				Status = '1' 
			WHERE Icard = matric;
		ELSIF (nTipo = 2) THEN			-- template Alternativo (2)
			UPDATE CONTDIG_SAGEM
			SET Templ_Alt1 = substr(templAlt,   1, 160),
				Templ_Alt2 = substr(templAlt, 161, 160),
				Templ_Alt3 = substr(templAlt, 321, 160),
				Templ_Alt4 = substr(templAlt, 481,  32),
				Status = '1' 
			WHERE Icard = matric;
		ELSIF (nTipo = 3) THEN			-- template Coacao (3)
			UPDATE CONTDIG_SAGEM
			SET Templ_Coa1 = substr(templCoa,   1, 160),
				Templ_Coa2 = substr(templCoa, 161, 160),
				Templ_Coa3 = substr(templCoa, 321, 160),
				Templ_Coa4 = substr(templCoa, 481,  32),
				Status = '1' 
			WHERE Icard = matric;
		ELSE				-- template Padrao e Alternativo (4)
			UPDATE CONTDIG_SAGEM
			SET Templ_Tit1 = substr(templPad,   1, 160),
				Templ_Tit2 = substr(templPad, 161, 160),
				Templ_Tit3 = substr(templPad, 321, 160),
				Templ_Tit4 = substr(templPad, 481,  32),
			    Templ_Alt1 = substr(templAlt,   1, 160),
				Templ_Alt2 = substr(templAlt, 161, 160),
				Templ_Alt3 = substr(templAlt, 321, 160),
				Templ_Alt4 = substr(templAlt, 481,  32),
				Status = '1' 
			WHERE Icard = matric;
		END IF;
	ELSIF (nRetorno = 0) THEN       
		-- matrcula nao existe, sera' inserido novo 
		IF (nTipo = 0) THEN          -- template todos (0)
			INSERT INTO CONTDIG_SAGEM (Icard, 
										Templ_tit1, Templ_tit2, Templ_tit3, Templ_tit4,
										Templ_Alt1, Templ_Alt2, Templ_Alt3, Templ_Alt4,
										Templ_Coa1, Templ_Coa2, Templ_Coa3, Templ_Coa4,
										Status)
			VALUES (matric, 
					substr(templPad,   1, 160),
					substr(templPad, 161, 160),
					substr(templPad, 321, 160),
					substr(templPad, 481,  32),
					substr(templAlt,   1, 160),
					substr(templAlt, 161, 160),
					substr(templAlt, 321, 160),
					substr(templAlt, 481,  32),
					substr(templCoa,   1, 160),
					substr(templCoa, 161, 160),
					substr(templCoa, 321, 160),
					substr(templCoa, 481,  32),
					'1');
		ELSIF (nTipo = 1) THEN          -- template padrao (1)
			INSERT INTO CONTDIG_SAGEM (Icard, Templ_tit1, Templ_tit2, Templ_tit3, Templ_tit4, Status)
			VALUES (matric, substr(templPad,   1, 160),
							substr(templPad, 161, 160),
							substr(templPad, 321, 160),
							substr(templPad, 481,  32),
							'1');
		ELSIF (nTipo = 2) THEN		-- template aLTERNATIVO (2)
			INSERT INTO CONTDIG_SAGEM (Icard, Templ_Alt1, Templ_Alt2, Templ_Alt3, Templ_Alt4, Status)
			VALUES (matric, substr(templAlt,   1, 160),
							substr(templAlt, 161, 160),
							substr(templAlt, 321, 160),
							substr(templAlt, 481,  32),
							'1');
		ELSIF (nTipo = 3) THEN		-- template COACAO (3)
			INSERT INTO CONTDIG_SAGEM (Icard, Templ_Coa1, Templ_Coa2, Templ_Coa3, Templ_Coa4, Status)
			VALUES (matric, substr(templCoa,   1, 160),
							substr(templCoa, 161, 160),
							substr(templCoa, 321, 160),
							substr(templCoa, 481,  32),
							'1');
		ELSIF (nTipo = 4) THEN		-- template COACAO (3)
			INSERT INTO CONTDIG_SAGEM (Icard, Templ_tit1, Templ_tit2, Templ_tit3, Templ_tit4,
										Templ_Alt1, Templ_Alt2, Templ_Alt3, Templ_Alt4, Status)
			VALUES (matric, substr(templPad,   1, 160),
							substr(templPad, 161, 160),
							substr(templPad, 321, 160),
							substr(templPad, 481,  32),
							substr(templAlt,   1, 160),
							substr(templAlt, 161, 160),
							substr(templAlt, 321, 160),
							substr(templAlt, 481,  32),
							'1');
		END IF;
		nRetorno := 1;
	END IF;
	COMMIT;     
	return (nRetorno);
END sagem_ins_digital;
/

