CREATE OR REPLACE FUNCTION sagem_del_digital (matric in VARCHAR2)
   RETURN NUMBER IS
   cAuxMat VARCHAR2(15);
   nRetorno NUMBER;
   reco_lock EXCEPTION;
   PRAGMA EXCEPTION_INIT (reco_lock,-54);  -- erro quando registro lockado 

BEGIN
	nRetorno := 1;
	BEGIN
		SELECT 	Icard into cAuxMat 
		FROM CONTDIG_SAGEM
		WHERE Icard = matric 
		FOR update nowait;
		
		DELETE CONTDIG_SAGEM WHERE Icard = matric;
		COMMIT;
		
	EXCEPTION
		WHEN NO_DATA_FOUND THEN nRetorno := 1;
		WHEN reco_lock THEN nRetorno := 0;
		WHEN OTHERS THEN nRetorno := -1;
	END;
	
	return (nRetorno);
	
END sagem_del_digital;
/

