CREATE or REPLACE FUNCTION sqlatu_pendon002_onoff(cTpCarga in VARCHAR2, nLivre in NUMBER,cEndIp in VARCHAR2, nLivreAux in NUMBER) 
RETURN NUMBER IS
cStatus char(1);
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);
nRet number;
x number;

begin
	nRet := 0;
	begin
		select /*+ INDEX (INDEX1_PEND_ON002ON) */
			STATUS into cStatus 
			from PEND_ON002ON
			where END_IP = cEndIp for update nowait;

		update /*+ INDEX (INDEX1_PEND_ON002ON) */
			PEND_ON002ON 
			set	QTD_LIVRE = nLivre
			where END_IP = cEndIp;
		COMMIT;
		
	exception
		when reco_lock then nRet := -1;
		when NO_DATA_FOUND then x := 0;
	end;

	begin
		select /*+ INDEX (INDEX1_PEND_ON002OFF) */
			STATUS_OFF into cStatus 
			from PEND_ON002OFF
			where END_IP = cEndIp for update nowait;

		update /*+ INDEX (INDEX1_PEND_ON002OFF) */
			PEND_ON002OFF 
			set	QTD_LIVREOFF = nLivreAux 
			where END_IP = cEndIp;
		COMMIT;
		
	exception
		when reco_lock then nRet := -1;
		when NO_DATA_FOUND then x := 0;
	end;

	return (nRet);

END sqlatu_pendon002_onoff;
/
