CREATE or REPLACE FUNCTION sqlatu_pendon002_off(cTpCarga in VARCHAR2, nLivre in NUMBER,cEndIp in VARCHAR2) RETURN NUMBER IS
cStatus char(1);
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);
nRet number;
x number;

begin
	nRet := 0;
	--dbms_output.put_line ('ctpcarga = ' || cTpCarga);

	if ((cTpCarga = '0') or (cTpCarga = '1') or (cTpCarga = '2') or	(cTpCarga = '3')) then
		begin
			select /*+ INDEX (INDEX1_PEND_ON002OFF) */
				STATUS_OFF into cStatus from PEND_ON002OFF
				where END_IP = cEndIp and STATUS_OFF = '2' for update nowait;
				
			BEGIN
				select 
					STATUS_OFF into cStatus from PEND_ON008OFF
					where END_IP = cEndIp for update nowait;

				-- 0 = Lista pendncia online foi carregada
				if (cTpCarga = '0') then
					update /*+ INDEX (INDEX1_PEND_ON002OFF) */
						PEND_ON002OFF 
						set STATUS_OFF = '3', 
							QTD_LIVREOFF = nLivre
					where END_IP = cEndIp;

				-- 1 = Lista pendencia online nao foi carregada devido a falta de espao
				elsif (cTpCarga = '1') then
					update /*+ INDEX (INDEX1_PEND_ON002OFF) */
						PEND_ON002OFF 
						set STATUS_OFF = '5', 
							QTD_LIVREOFF = nLivre
					where END_IP = cEndIp;

				-- 2 = Lista pendencia online nao foi carregada devido a outros erros
				elsif (cTpCarga = '2') then
					update /*+ INDEX (INDEX1_PEND_ON002OFF) */
						PEND_ON002OFF 
						set STATUS_OFF = '4', 
							QTD_LIVREOFF = nLivre
					where END_IP = cEndIp;

				-- 3 = Lista pendencia online nao foi carregada pois codin no respondeu
				else  --(cTpCarga = '3') 
					update /*+ INDEX (INDEX1_PEND_ON002OFF) */
						PEND_ON002OFF 
						set STATUS_OFF = '4'
						where END_IP = cEndIp;
				end if;
	
				COMMIT;
				
			EXCEPTION
				when reco_lock then 
					ROLLBACK;
					nRet := -1;
				when NO_DATA_FOUND then x := 0;
			END;
			
		EXCEPTION
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then x := 0;
		end;
		
		
 	elsif (cTpCarga = '4') THEN 	-- cTpCarga = '4' = Houve comando de carga  Aplicativo , deve alterar qtde livre 
 		BEGIN
 			select /*+ INDEX (INDEX1_PEND_ON002OFF) */
				STATUS_OFF into cStatus from PEND_ON002OFF
				where END_IP = cEndIp and 
					  STATUS_OFF <> '6' 
				for update nowait;

			BEGIN
				select 
					STATUS_OFF into cStatus from PEND_ON008OFF
					where END_IP = cEndIp  
					for update nowait;
			
				update /*+ INDEX (INDEX1_PEND_ON002OFF) */
					PEND_ON002OFF 
					set STATUS_OFF = '6', 
						QTD_LIVREOFF = 1
					where END_IP = cEndIp;
					
				COMMIT;

			EXCEPTION
				when reco_lock then 
					rollback;
					nRet := -1;
				when NO_DATA_FOUND then x := 0;
			END;
			
		EXCEPTION
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then x := 0;
		END;
			

	elsif (cTpCarga = '5') then       -- 5 = somente indicacao de qtde.livre no codin					
		BEGIN
 			select /*+ INDEX (INDEX1_PEND_ON002OFF) */
				STATUS_OFF into cStatus from PEND_ON002OFF
				where END_IP = cEndIp 
				for update nowait;

			update /*+ INDEX (INDEX1_PEND_ON002OFF) */
				PEND_ON002OFF 
				set	QTD_LIVREOFF = nLivre 
				where END_IP = cEndIp;
				
			COMMIT;
			
		EXCEPTION
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then x := 0;
		END;
			
					
	else	--(cTpCarga = '6')
		BEGIN
 			select /*+ INDEX (INDEX1_PEND_ON002OFF) */
				STATUS_OFF into cStatus from PEND_ON002OFF
				where END_IP = cEndIp AND
					STATUS_OFF <> '6' 
				for update nowait;
	
			BEGIN
				select 
					STATUS_OFF into cStatus from PEND_ON008OFF
					where END_IP = cEndIp 
					for update nowait;
	
		
				update /*+ INDEX (INDEX1_PEND_ON002OFF) */
					PEND_ON002OFF 
					set	STATUS_OFF = '6', 
					    QTD_LIVREOFF = 0 
					where END_IP = cEndIp;

				COMMIT;
				
			EXCEPTION
				when reco_lock then 
					ROLLBACK;
					nRet := -1;
				when NO_DATA_FOUND then x := 0;
			END;
			
		EXCEPTION
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then nRet := 0;
		END;
		
	end if;
	return (nRet);

END sqlatu_pendon002_off;
/
