CREATE or REPLACE FUNCTION sqlatu_pendon002_lpz(cTpCarga in VARCHAR2, nLivre in NUMBER,cEndIp in VARCHAR2, nLivreAux in NUMBER) 
RETURN NUMBER IS
cStatus char(1);
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);
nRet number;
x number;

begin
	nRet := 0;

	-- 0 = Lista Limpeza foi carregada
	if (cTpCarga = '0') then
		BEGIN
			select /*+ INDEX (INDEX1_PEND_ON002LPZ) */
				STATUS_LPZ into cStatus from PEND_ON002LPZ
			where END_IP = cEndIp and STATUS_LPZ = '2' for update nowait;

			update /*+ INDEX (INDEX1_PEND_ON002LPZ) */
				PEND_ON002LPZ 
				set STATUS_LPZ = '0' 
			where END_IP = cEndIp;
			COMMIT;
			
		exception
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then x := 0;
		end;
		
		BEGIN
			select /*+ INDEX (INDEX1_PEND_ON002ON) */
				STATUS into cStatus from PEND_ON002ON
				where END_IP = cEndIp and
					STATUS <> '8' 
				for update nowait;

			BEGIN
				select 
					STATUS into cStatus from PEND_ON008ON
					where END_IP = cEndIp 
					for update nowait;

				update /*+ INDEX (INDEX1_PEND_ON002ON) */
					PEND_ON002ON 
					SET	QTD_LIVRE = nLivre,
						STATUS = '8'		
					where END_IP = cEndIp;
				COMMIT;
				
			EXCEPTION
				when reco_lock then 
					nRet := -1;
					ROLLBACK;
				when NO_DATA_FOUND then x := 0;
			END;
			
		EXCEPTION
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then x := 0;
		end;


		BEGIN
			select /*+ INDEX (INDEX1_PEND_ON002OFF) */
				STATUS_OFF into cStatus from PEND_ON002OFF
				where END_IP = cEndIp and
					  STATUS_OFF <> '8' 
				for update nowait;

			BEGIN
				select 
					STATUS_OFF into cStatus from PEND_ON008OFF
					where END_IP = cEndIp 
					for update nowait;
			
				update /*+ INDEX (INDEX1_PEND_ON002OFF) */
					PEND_ON002OFF 
					SET	QTD_LIVREOFF = nLivreAux,
						STATUS_OFF = '8'		
					where END_IP = cEndIp  ;

				COMMIT;
				
			EXCEPTION
				when reco_lock then 
					nRet := -1;
					ROLLBACK;
				when NO_DATA_FOUND then x := 0;
			END;
				
		exception
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then x := 0;
		end;

	-- 1 = Lista Limpeza nao foi carregada devido a falta de espao
	elsif (cTpCarga = '1') then
		update /*+ INDEX (INDEX1_PEND_ON002LPZ) */
			PEND_ON002LPZ 
			set STATUS_LPZ = '4' 
		where END_IP = cEndIp;

	-- 2 = Lista Limpeza nao foi carregada devido a outros erros
	elsif ((cTpCarga = '2') or (cTpCarga = '3'))  then
		update /*+ INDEX (INDEX1_PEND_ON002LPZ) */
			PEND_ON002LPZ 
			set STATUS_LPZ = '4'
		where END_IP = cEndIp;
		
		COMMIT;

	end if;
	return (nRet);

END sqlatu_pendon002_lpz;
/
