CREATE OR REPLACE FUNCTION sqlcon_tipo_bloq (cTipo IN VARCHAR2, cTamTipo IN varchar2, mensagem OUT VARCHAR2) 
   RETURN NUMBER IS
      RetFun NUMBER;
      TipoAux   VARCHAR2(10);
      BloqAux  VARCHAR2(1);
      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado 
BEGIN
   RetFun := 0;       -- assume matricula encontrada
   BEGIN
   SELECT Tipo, Bloqueado into TipoAux, BloqAux FROM BLOQTIPO
      -- WHERE substr(Tipo,1,to_number(cTamTipo)) = cTipo;
	WHERE TO_NUMBER(Tipo) = TO_NUMBER(cTipo);

   IF (BloqAux = '1') THEN
	RetFun := 1;
        mensagem := 'Tipo '|| cTipo || ' bloqueado';
   ELSIF (BloqAux = '0') THEN
	RetFun := 0;
	mensagem := 'Tipo '|| cTipo || ' nao bloqueado';
   ELSE
	RetFun := -1;
	mensagem := 'Lista Tipo com valor bloqueado diferente de 0/1';
   END IF;


   EXCEPTION
      WHEN reco_lock THEN
         RetFun := -1;              -- reg. lockado
         mensagem := 'Tipo '|| cTipo ||' lockado!! Retorno = '|| TO_CHAR (RetFun);
      WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
         RetFun := -2;
         mensagem := 'Tipo ' || cTipo || ' nao encontrado !! Retorno = '|| TO_CHAR(RetFun);
      WHEN OTHERS THEN              -- outros erros
         RetFun := -1;
         mensagem := 'Outros erros encontrados em lst TIPO!! Retorno = '|| TO_CHAR(RetFun);
   END;
   return (RetFun);
END sqlcon_tipo_bloq;
/

