CREATE OR REPLACE FUNCTION sqllim_tempo_cred2 (cMatric IN VARCHAR2, cData in VARCHAR2, nTipo IN NUMBER) 
   RETURN NUMBER IS
   RetFun NUMBER;
   xAno varchar2(2);
   xMes varchar2(2);
   xDia varchar2(2);
   xHora varchar2(2);
   xMinuto varchar2(2);
   xLinha varchar(14);
   cAno varchar2(2);
   cMes varchar2(2);
   cDia varchar2(2);
   cHora varchar2(2);
   cMinuto varchar2(2);
   nCont number;
   nTempoB number;
   nTempoR number;
   nTempo number;
   horario1 number(10,0);
   horario2 number(10,0);
   xBranco varchar2(2);

BEGIN
    RetFun := 1;
    nTempoB := 3;		-- tempo limite minimo de Beneficio
    nTempoR := 3;		-- tempo limite minimo de Refeitorio
    nCont := 0;
    xBranco := '  ';


    cDia := substr(cData,1,2);
    cMes := substr(cData,3,2);
    cAno := substr(cData,5,2);
    cHora := substr(cData,7,2);
    cMinuto := substr(cData,9,2);

    IF (nTipo = 1) THEN		-- nTipo = 1 : Beneficio
		nTempo := nTempoB;
		IF (nTempo = 0) THEN
			return (RetFun);
		END IF;
		SELECT count(*) INTO nCont FROM CREDLOG 
				WHERE ICARD = cMatric and 
					  TIPO = to_char(nTipo);
		IF (nCont > 0) THEN
			SELECT MAX(ANO||MES||DIA||HORA) into xLinha FROM CREDLOG 
				WHERE ICARD = cMatric and TIPO = to_char(nTipo); 
			xAno := substr(xLinha,3,2);            	
			xMes := substr(xLinha,5,2);
			xDia := substr(xLinha,7,2);
			xHora := substr(xLinha,9,2);
			xMinuto := substr(xLinha,11,2);
		ELSE
			return (RetFun);
		END IF;
    ELSE			-- nTipo = 0 : Refeitorio
		nTempo := nTempoR;
		IF (nTempo = 0) THEN
			return (RetFun);
		END IF;
		xDia := substr(cData,11,2);
		xMes := substr(cData,13,2);
		xAno := substr(cData,15,2);
		xHora := substr(cData,17,2);
		xMinuto := substr(cData,19,2);
    END IF;

	IF ((xDia = xBranco) or (xMes = xBranco) or (xAno = xBranco) or (xHora = xBranco) or (xMinuto = xBranco)) THEN
		return (RetFun);
	END IF;

    horario1 := to_number(cMinuto)+(to_number(cHora)*60)+(to_number(cDia)*24*60)+(to_number(cMes)*31*24*60)+(to_number(cAno)*12*31*24*60);
    horario2 := to_number(xMinuto)+(to_number(xHora)*60)+(to_number(xDia)*24*60)+(to_number(xMes)*31*24*60)+(to_number(xAno)*12*31*24*60);
    IF (horario1 >= horario2) and (horario1 <= (horario2+nTempo)) THEN		
		RetFun := 0;
    END IF;       
    return (RetFun);

END sqllim_tempo_cred2;
/

