CREATE OR REPLACE FUNCTION sqlcons_templ (cMatric in VARCHAR2, nTipoD in NUMBER, 
cTempl1 IN OUT VARCHAR2, cTempl2 IN OUT VARCHAR2, 
cTempl3 IN OUT VARCHAR2, cTempl4 IN OUT VARCHAR2, cTempl5 IN OUT VARCHAR2)
    RETURN NUMBER IS
      RetFun     NUMBER;
      Alt 	 NUMBER;
      Pad 	 NUMBER;
      cTemplAux1 VARCHAR2(160);
      cTemplAux2 VARCHAR2(160);
      cTemplAux3 VARCHAR2(160);
      cTemplAux4 VARCHAR2(160);
      cTemplAux5 VARCHAR2(56);

BEGIN
    RetFun := 1;
    BEGIN
	SELECT 
	    Templ_Tit1, Templ_Tit2, Templ_Tit3, Templ_Tit4, Templ_Tit5,
	    Templ_Alt1, Templ_Alt2, Templ_Alt3, Templ_Alt4, Templ_Alt5
	INTO 	
	    cTemplAux1, cTemplAux2, cTemplAux3, cTemplAux4, cTemplAux5,
	    cTempl1, cTempl2, cTempl3, cTempl4, cTempl5

	FROM CONTDIG_VERI 	
	WHERE Icard = cMatric;

    EXCEPTION
	WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado	
	    return (3);
	WHEN OTHERS THEN              -- outros erros
	    return (-1);
    END;

    Alt := 1;	-- assume que existe alternativo
    IF ((cTempl1 is Null) or (cTempl2 is Null) or 
	(cTempl3 is Null) or (cTempl4 is Null) or (cTempl5 is Null) or
        (length(cTempl1) < 160) or (length(cTempl2) < 160) or
        (length(cTempl3) < 160) or (length(cTempl4) < 160) or 
	(length(cTempl5) < 56)) THEN
	Alt := 0;	-- nao existe alternativo
    END IF;

    Pad := 1;	-- assume que existe padrao
    IF ((cTemplAux1 is Null) or (cTemplAux2 is Null) or 
	(cTemplAux3 is Null) or (cTemplAux4 is Null) or (cTemplAux5 is Null) or
        (length(cTemplAux1) < 160) or (length(cTemplAux2) < 160) or
        (length(cTemplAux3) < 160) or (length(cTemplAux4) < 160) or 
	(length(cTemplAux5) < 56)) THEN
	Pad := 0;	-- nao existe padrao
    END IF;

    IF ((nTipoD = 0) and (Alt = 0)) THEN	-- estapedindo alternativo mas nao tem alternativo
	Return (0);
    END IF;

    IF (nTipoD = 1) THEN		-- pedido de template padrao
	cTempl1 := cTemplAux1;
	cTempl2 := cTemplAux2;
	cTempl3 := cTemplAux3;
	cTempl4 := cTemplAux4;
	cTempl5 := cTemplAux5;
	IF (Pad = 0) THEN	
	    Return (0);
	END IF;
    ELSIF (nTipoD = 2) THEN		-- pedido de template padrao e alternativo
	cTempl1 := cTemplAux1 || cTempl1;
	cTempl2 := cTemplAux2 || cTempl2;
	cTempl3 := cTemplAux3 || cTempl3;
	cTempl4 := cTemplAux4 || cTempl4;
	cTempl5 := cTemplAux5 || cTempl5;
	IF ((Alt = 0) or (Pad = 0)) THEN
	    Return (0);
	END IF;
    END IF;
    return (RetFun);

END sqlcons_templ;
/
