CREATE OR REPLACE FUNCTION sqlsit_coletor (cTipo in VARCHAR2, pt_sitcolet in VARCHAR2)
   RETURN NUMBER IS
	nRet NUMBER;
	cEndIp VARCHAR2(15);
	cBlueB VARCHAR2(2);
	cTerm VARCHAR2(2);
	cIdConex VARCHAR2(15);
	cDisp VARCHAR2(1);
	cData VARCHAR2(12);
	cDataSit VARCHAR2(17);
	cAux VARCHAR2(15);
	reco_lock EXCEPTION;
	PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado 
BEGIN
	nRet := 0;
	cEndIp := 	SUBSTR (pt_sitcolet,  1, 15);
	cBlueB := 	SUBSTR (pt_sitcolet, 16,  2);
	cTerm  := 	SUBSTR (pt_sitcolet, 18,  2);
	cIdConex :=	SUBSTR (pt_sitcolet, 20, 15);
	cDisp := 	SUBSTR (pt_sitcolet, 35,  1);
	cData := 	SUBSTR (pt_sitcolet, 36, 12);

	--tipo '1' = codin arl, '2' = codin tcp, tipo '3' = Arlonp, tipo '4' = Conex
	IF (cTipo = '1') THEN
		-- Codin ARL
		BEGIN
			SELECT ID_CONEX into cAux from SITCOLETOR 
				WHERE BLUEB = cBlueB and CODIN = cTerm;
			SELECT ID_CONEX into cAux from SITCOLETOR 
				WHERE BLUEB = cBlueB and CODIN = cTerm 
				FOR UPDATE NOWAIT;

			-- atualiza linha
			UPDATE SITCOLETOR SET 
				ID_CONEX = cIdConex,
				DT_ATUALI = TO_DATE(cData,'DDMMYYHH24MISS')
			WHERE BLUEB = cBlueB and CODIN = cTerm;
				
		EXCEPTION
			WHEN reco_lock THEN nRet := -1;
			WHEN NO_DATA_FOUND THEN 
				-- insere linha
				INSERT INTO SITCOLETOR 
					(ENDIP, BLUEB, CODIN, ID_CONEX, DISPOSITIVO, DT_ATUALI) 
				VALUES
					(cEndIp, cBlueB, cTerm, cIdConex, cDisp, TO_DATE(cData,'DDMMYYHH24MISS'));
		END;
	
	ELSIF (cTipo = '2') THEN
		-- codin TCP		
		BEGIN
			SELECT ID_CONEX into cAux from SITCOLETOR 
				WHERE ENDIP = cEndIp;
			SELECT ID_CONEX into cAux from SITCOLETOR 
				WHERE ENDIP = cEndIp 
				FOR UPDATE NOWAIT;

			-- atualiza linha
			UPDATE SITCOLETOR SET 
				ID_CONEX = cIdConex,
				DT_ATUALI = TO_DATE(cData,'DDMMYYHH24MISS')
			WHERE ENDIP = cEndIp;
				
		EXCEPTION
			WHEN reco_lock THEN nRet := -1;
			WHEN NO_DATA_FOUND THEN 
				-- insere linha
				INSERT INTO SITCOLETOR 
					(ENDIP, BLUEB, CODIN, ID_CONEX, DISPOSITIVO, DT_ATUALI) 
				VALUES
					(cEndIp, cBlueB, cTerm, cIdConex, cDisp, TO_DATE(cData,'DDMMYYHH24MISS'));
		END;

	ELSIF (cTipo = '3') THEN
		-- Arlonp
		BEGIN
			SELECT ID_CONEX into cAux from SITCOLETOR 
				WHERE BLUEB = cBlueB and CODIN = '99';
			SELECT ID_CONEX into cAux from SITCOLETOR 
				WHERE BLUEB = cBlueB and CODIN = '99'
				FOR UPDATE NOWAIT;

			UPDATE SITCOLETOR SET 
				ID_CONEX = cIdConex,
				DT_ATUALI = TO_DATE(cData,'DDMMYYHH24MISS') 
			WHERE BLUEB = cBlueB and CODIN = '99';
	
				
		EXCEPTION
			WHEN reco_lock THEN nRet := -1;
			WHEN NO_DATA_FOUND THEN 
				-- insere linha
				INSERT INTO SITCOLETOR 
					(ENDIP, BLUEB, CODIN, ID_CONEX, DISPOSITIVO, DT_ATUALI) 
				VALUES
					(cEndIp, cBlueB, '99', cIdConex, cDisp, TO_DATE(cData,'DDMMYYHH24MISS'));
		END;
	ELSIF (cTipo = '4') THEN
		-- Conex		
		BEGIN
			SELECT ID_CONEX into cAux from SITCOLETOR 
				WHERE ENDIP = cEndIp and ID_CONEX = cIdConex and BlueB = '00';
			SELECT ID_CONEX into cAux from SITCOLETOR 
				WHERE ENDIP = cEndIp  and ID_CONEX = cIdConex  and BlueB = '00' 
				FOR UPDATE NOWAIT;

			UPDATE SITCOLETOR SET 
				-- ID_CONEX = cIdConex,
				DT_ATUALI = TO_DATE(cData,'DDMMYYHH24MISS')
			WHERE ENDIP = cEndIp  and ID_CONEX = cIdConex and BlueB = '00';
				
		EXCEPTION
			WHEN reco_lock THEN nRet := -1;
			WHEN NO_DATA_FOUND THEN 
				-- insere linha
				INSERT INTO SITCOLETOR 
					(ENDIP, BLUEB, CODIN, ID_CONEX, DISPOSITIVO, DT_ATUALI) 
				VALUES
					(cEndIp, cBlueB, cTerm, cIdConex, cDisp, TO_DATE(cData,'DDMMYYHH24MISS'));
		END;
	END IF;
	COMMIT;
	return (nRet);
END sqlsit_coletor;
/


