--**********************************************************************************************
--		I N I C I O   D A   P R O C E D U R E    SP_CARTAOATUALIZADO
--**********************************************************************************************

CREATE OR REPLACE  PROCEDURE SP_CARTAOATUALIZADO  is

TYPE identif_p07 IS TABLE OF pend_on007.identif%TYPE INDEX BY binary_integer;

TYPE numserial_p07 IS TABLE OF pend_on007.numserial%TYPE INDEX BY binary_integer;

TYPE evento_p07 IS TABLE OF pend_on007.evento%TYPE INDEX BY binary_integer;

TYPE tpatu_p07 IS TABLE OF pend_on007.tipo_atu%TYPE INDEX BY binary_integer;
	
TYPE rowid_varray IS VARRAY (2000) OF ROWID; 	

l_identif identif_p07;
l_numserial numserial_p07;
l_evento evento_p07;
l_tipo_atu tpatu_p07;
l_rowid rowid_varray;

reco_lock EXCEPTION;
tem_deadlock EXCEPTION; 
PRAGMA EXCEPTION_INIT (reco_lock, -54);  
PRAGMA EXCEPTION_INIT (tem_deadlock, -60); 
  
total NUMBER;

p_rec pend_on001%rowtype;
atu_rec atuali%rowtype;

BEGIN

	SELECT identif, numserial, evento, tipo_atu, rowid 
		BULK COLLECT INTO l_identif, l_numserial, l_evento, l_tipo_atu, l_rowid 
		FROM pend_on007 
		WHERE ROWNUM < 1000;
	
	total := l_identif.count;

	FOR i in 1 .. total
	LOOP

    	----------------------------------------------------------------------------------------------------------------------------------------
		-- TIPO_ATU '1' INDICA QUE A ATUALIZACAO FOI FEITA QUANDO CODIN ESTAVA ONLINE (AS ATUALIZACOES PROVENIENTES DA BD) 
		-- TIPO_ATU '0' INDICA QUE A ATUALIZACAO FOI FEITA QUANDO CODIN ESTAVA OFFLINE (ATUALIZANDO SOMENTE COM  A INFO QUE ESTAVA NA MEMO DO CODIN) 
		---------------------------------------------------------------------------------------------------------------------------------------
		IF (l_tipo_atu(i) = '1') then	
			for c1 in (select rowid from pend_on001 
						where 	numserial = l_numserial(i) and	
								end_ip > '000.000.000.000' and
								identif <= l_identif(i))
			loop
				BEGIN
					select * into p_rec from pend_on001 where rowid = c1.rowid for update nowait;		
					delete from pend_on001 where rowid = c1.rowid;

				EXCEPTION
					when reco_lock then NULL ;
					when tem_deadlock then NULL ;
					when NO_DATA_FOUND then NULL;
					when OTHERS then NULL;
				END;
			end loop;					

			for b1 in (select rowid from atuali 
						where	numserial = l_numserial(i) and
								identif <= l_identif(i))
			loop
				begin
					select * into atu_rec from atuali where rowid = b1.rowid for update nowait;
					delete from atuali where rowid = b1.rowid;
						
				exception
					when reco_lock then NULL ;
					when NO_DATA_FOUND then NULL;
					when OTHERS then NULL;
				end;
			end loop;			
			

		ELSE
			for c1 in (select rowid from pend_on001 
						where 	numserial = l_numserial(i) and	
								end_ip > '000.000.000.000' and
								identif <= l_identif(i) and 
								tipo_atu = '0')
			loop
				BEGIN
					select * into p_rec from pend_on001 where rowid = c1.rowid for update nowait;		
					delete from pend_on001 where rowid = c1.rowid;

				EXCEPTION
					when reco_lock then NULL;
					when tem_deadlock then NULL;
					when NO_DATA_FOUND then NULL;
					when OTHERS then NULL;
				END;
			end loop;					

			for b1 in (select rowid from atuali 
						where 	numserial = l_numserial(i) and
								identif <= l_identif(i)  and
								to_number(numcpo) in (2,14,15,19,25,26,27,28,29,30,31,32,33,34,35,36,37,59,61,62,63,64,65,66)) 
			loop
				begin
					select * into atu_rec from atuali where rowid = b1.rowid for update nowait;
					delete from atuali where rowid = b1.rowid;
						
				exception
					when reco_lock then NULL ;
					when NO_DATA_FOUND then NULL;
					when OTHERS then NULL;
				end;
			end loop;			

		END IF ;  

		COMMIT;
	
	END LOOP ;

	IF (total != 0) then
		FOR i in 1 .. total
		LOOP
			DELETE FROM PEND_ON007 
				WHERE rowid = l_rowid(i);
		END LOOP;
		
		COMMIT;
	END IF;

end sp_cartaoatualizado ;
/
