
--**********************************************************************************************
--		I N I C I O   D A   P R O C E D U R E   SP2A_STATUSON    
--**********************************************************************************************
CREATE OR REPLACE  PROCEDURE SP2A_STATUSON is 

reco_lock EXCEPTION;
tem_deadlock EXCEPTION; 
PRAGMA EXCEPTION_INIT (reco_lock, -54);  
PRAGMA EXCEPTION_INIT (tem_deadlock, -60); 
rstatus varchar(1);

TYPE endip_type IS TABLE OF pend_on008on.end_ip%TYPE 
	INDEX BY binary_integer;
TYPE status_type IS TABLE OF pend_on008on.status%TYPE 
	INDEX BY binary_integer;
TYPE qhorexp_type IS TABLE OF pend_on008on.qhor_exp%TYPE 
	INDEX BY binary_integer;

l_endip endip_type;
l_status status_type;
l_qhorexp qhorexp_type;
p_rec pend_on001%rowtype;
aux  varchar(1);
contador number;

BEGIN

	------------------------------------------------
	-- I N I C I O   D A   P A R T E   O N   L I N E
	------------------------------------------------
	SELECT END_IP, STATUS, QHOR_EXP 
	BULK COLLECT INTO l_endip, l_status, l_qhorexp 	
		FROM PEND_ON008ON 
		--where status in ('3','4','5','6','7','8');
		where status in ('3','4','5','7','8');
		
	FOR indx in 1 .. l_endip.count 
	LOOP	
		-----------------------------------
		-- S U C E S S O   N O   E N V I O 
		-----------------------------------
		IF l_status(indx) = '3' THEN 		

			for r in ( select * from PEND_ON003 where end_ip = l_endip(indx) ) 
			LOOP
				for c_fon in (select rowid, identif from pend_on001 p1 
					where 
						p1.numserial = r.numserial and  
						p1.end_ip = r.end_ip and 
						p1.identif <= r.identif and
						p1.tipo_atu = '1' )
				LOOP
					BEGIN
						select * INTO p_rec from pend_on001 p1
							where rowid = c_fon.rowid 
						for update nowait;

						IF c_fon.identif = r.identif then
							update pend_on001 p1 set 
								status = '5' ,
								data_exp = SYSDATE + 1 / 24 * l_qhorexp(indx)
							where rowid = c_fon.rowid ;
							
						ELSE
							delete pend_on001 
								where rowid = c_fon.rowid;
						END IF;

					EXCEPTION
						when reco_lock then NULL;
						when tem_deadlock then NULL;
						when NO_DATA_FOUND then NULL;
						when OTHERS then NULL;
					END;

				END LOOP;							
				
			END LOOP;							
	
			BEGIN
				select status into aux from pend_on008on where end_ip = l_endip(indx) for update nowait;
	
				update pend_on008ON set status = '0' where end_ip = l_endip(indx);
	
				update pend_on002ON set status = '0' where end_ip = l_endip(indx) ;
	
				delete from PEND_ON003 where end_ip = l_endip(indx) ;
	
			EXCEPTION
				when reco_lock then NULL;
				when tem_deadlock then NULL;
			END;
				
			COMMIT;
		
		------------------------------------------
		-- F A L H A   N A   T R A N S M I S S  O 
		------------------------------------------
		ELSIF l_status(indx) = '4' then

			update pend_on008ON set status = '0' where end_ip = l_endip(indx);
			update pend_on002ON set status = '1' where end_ip = l_endip(indx);		

			COMMIT;

		------------------------------------------------
		-- E X C E D E U   L I M I T E   D E   L I S T A 
		------------------------------------------------
		ELSIF l_status(indx) = '5' then
			contador := 0;			
			
			for r in ( select * from pend_on003 where end_ip = l_endip(indx) ) 
			LOOP
				for c_fon in (select rowid from pend_on001 p1 
					where 
						p1.numserial = r.numserial and  
						p1.end_ip = r.end_ip and 
						p1.identif <= r.identif and
						p1.tipo_atu = '1' and
						p1.status = '1' )

				LOOP
					BEGIN
						select * INTO p_rec from pend_on001 p1
							where rowid = c_fon.rowid 
						for update nowait;

						update pend_on001 p1 set status = '0' 
							where rowid = c_fon.rowid ;
							
					EXCEPTION
						when reco_lock then contador := 1;
						when tem_deadlock then contador := 1;
						when NO_DATA_FOUND then NULL;
						when OTHERS then NULL;
					END;
				END LOOP;							

			END LOOP ;

			IF (contador = 0) then
				begin
					select status into aux from pend_on008on where end_ip = l_endip(indx) for update nowait;

					update pend_on008ON set status = '0' where end_ip = l_endip(indx) ;

					update pend_on002ON set status = '0' where end_ip = l_endip(indx)  ;

					delete from pend_on003 where end_ip = l_endip(indx)  ;

				exception
					when reco_lock then NULL;
					when tem_deadlock then NULL;
				end;
			end if;

			COMMIT;

		----------------------------------------------------------------------------
		-- 6 = A P A G O U    A P L I C A T I V O (	nao sera tratado )  
		-- 7 = L I M P O U   M E M O R I A   D O   C O D I N   V I A   C O M A N D O  ou
		--     atraves comando datahora apos apagar memoria e carga de aplicativo
		-- 8 = L I M P E Z A   M E M O R I A   D O   C O D I N   V I A   A G E N D A M E N T O (PEND_ON002LPZ)
		----------------------------------------------------------------------------
		--ELSIF (l_status(indx) = '6' or l_status(indx) = '7' or l_status(indx) = '8') then
		ELSIF (l_status(indx) = '7' or l_status(indx) = '8') then
			for c_on in (
				select rowid from pend_on001
				where 
					end_ip = l_endip(indx) and 
					tipo_atu = '1' and
					status in ( '1', '5' ) )
			loop
				BEGIN
					select * into p_rec from pend_on001
						where rowid = c_on.rowid
					for update nowait;
					
					update pend_on001 set status = '0' 
						where rowid = c_on.rowid;
						
				EXCEPTION
					when reco_lock then NULL;
					when tem_deadlock then NULL;
					when NO_DATA_FOUND then NULL;
					when OTHERS then NULL;
				END;
			end loop;

			BEGIN
				select STATUS INTO aux from pend_on008ON where end_ip = l_endip(indx)  for update nowait;
				update pend_on008ON set status = '0' where end_ip = l_endip(indx) ;
				update pend_on002ON set status = '0' where end_ip = l_endip(indx) ;
				delete from pend_on003 p3 where p3.end_ip = l_endip(indx)  ;

			EXCEPTION
				when reco_lock then NULL;
				when tem_deadlock then NULL;
			END;

			COMMIT;
				
		END IF ;
		
	END LOOP;

	update pend_on002ON set status = '4' 
		where (status = '2' or status = '4') and data_ini + ( 1 / 24 / 60 )  < sysdate; 
	COMMIT;
	
	-------------------------------------------
	-- F I M    D A   P A R T E   O N   L I N E
	-------------------------------------------
 
end SP2A_STATUSON ;
/

