CREATE or REPLACE FUNCTION sqlapl_recarga(cEndIp in VARCHAR2) RETURN NUMBER IS

cStatus char(1);
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);
nContOn number;
nContOff number;

begin
	-- apos apagar e recarga de aplicativo, deve-se reenviar as pendencias do codin
	nContOn := 0;
	nContOff := 0;
	BEGIN
		-- verifica se houve comando de apagar aplicativo anteriormente
		select STATUS into cStatus from PEND_ON002ON
			where END_IP = cEndIp and STATUS = '6'
			for update nowait;
		begin
			select STATUS into cStatus from PEND_ON008ON
				where END_IP = cEndIp and STATUS = '6'
				for update nowait;
			update PEND_ON002ON  
				set STATUS = '7', 
					QTD_LIVRE = 1
				where END_IP = cEndIp and STATUS = '6';
			nContOn := 1;

		exception
			when reco_lock then nContOn := -1;
			when NO_DATA_FOUND then nContOn := 0;
		end;

	EXCEPTION
		when reco_lock then nContOn := -1;
		when NO_DATA_FOUND then nContOn := 0;
	END;
			
	BEGIN
		-- verifica se houve comando de apagar aplicativo anteriormente
		select STATUS_OFF into cStatus from PEND_ON002OFF
			where END_IP = cEndIp and STATUS_OFF = '6' 
			for update nowait;
		begin
			select STATUS_OFF into cStatus from PEND_ON008OFF
				where END_IP = cEndIp  and STATUS_OFF = '6';
			update PEND_ON002OFF   
				set	STATUS_OFF = '7',
					QTD_LIVREOFF = 1
				where END_IP = cEndIp and STATUS_OFF = '6';
			nContOff := 1;
				
		exception
			when reco_lock then nContOff := -1;
			when NO_DATA_FOUND then nContOff := 0;
		end;

	EXCEPTION
		when reco_lock then nContOff := -1;
		when NO_DATA_FOUND then nContOff := 0;
	END;
		
	COMMIT;

	-- se houve algum registro lockado, retorna -1
	if (nContOn = -1 or nContOff = -1) then
		return (-1);		
	end if;
	
	
	if (nContOn = 1 or nContOff = 1) then
		return (1);		
	end if;
	
	return (0);
	
END sqlapl_recarga;
/
