CREATE OR REPLACE FUNCTION sqlproc_VERI_template_tcp (MATRIC VARCHAR2, T_TIT1 IN OUT VARCHAR2, T_TIT2 IN OUT VARCHAR2, 
T_TIT3 IN OUT VARCHAR2, T_TIT4 IN OUT VARCHAR2, T_ALT1 IN OUT VARCHAR2, T_ALT2 IN OUT VARCHAR2,
T_ALT3 IN OUT VARCHAR2, T_ALT4 IN OUT VARCHAR2, cNivel IN OUT VARCHAR2,
T_TIT5 IN OUT VARCHAR2, T_ALT5 IN OUT VARCHAR2)
   RETURN NUMBER IS
      Retfun NUMBER;
      RECO_LOCK EXCEPTION;
      PRAGMA EXCEPTION_INIT(RECO_LOCK, -54);
      AUX VARCHAR2(15);
      Alt NUMBER;
      Pad NUMBER;

BEGIN

   Retfun := 3;      -- sem templ padrao e sem templ alternativo
   BEGIN
       SELECT TEMPL_TIT1, TEMPL_TIT2, TEMPL_TIT3, TEMPL_TIT4, TEMPL_TIT5,
	      TEMPL_ALT1, TEMPL_ALT2, TEMPL_ALT3, TEMPL_ALT4, TEMPL_ALT5,
	      NIVEL
       INTO 
	      T_TIT1, T_TIT2, T_TIT3, T_TIT4, T_TIT5,
	      T_ALT1, T_ALT2, T_ALT3, T_ALT4, T_ALT5,
	      cNivel 
       FROM CONTDIG_VERI WHERE ICARD = MATRIC;


	Pad := 1;    -- assume que tem template padrao
	Alt := 1;    -- assume que tem template alternativo
	if ((T_tit1 is Null) or (T_tit2 is Null) or 
	    (T_tit3 is Null) or (T_tit4 is Null) or
            (T_tit5 is Null) or
            (length(T_tit1) < 160) or (length(T_tit2) < 160) or
            (length(T_tit3) < 160) or (length(T_tit4) < 160) OR
            (length(T_tit5) < 56)) then
	    Pad := 0;
	end if;

	if ((T_alt1 is Null) or (T_alt2 is Null) or
	    (T_alt3 is Null) or (T_alt4 is Null) or
            (T_alt5 is Null) or
  	    (length(T_alt1) < 160) or (length(T_alt2) < 160) or
    	    (length(T_alt3) < 160) or (length(T_alt4) < 160) OR
            (length(T_alt5) < 56)) then 
	    Alt := 0;
	end if;

	if (Pad = 1) then
	    if (Alt = 1) 
		then Retfun := 0;   -- tem padrao e tem alternativo
		else Retfun := 1;   -- tem padrao e nao tem alternativo
    	    end if;
	end if;

	if (Pad = 0) then
	    if (Alt = 1) 
		then Retfun := 2;   -- nao tem padrao e tem alternativo
		else Retfun := 3;   -- nao tem padrao e nao tem alternativo
    	    end if;
	end if;

   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		Retfun := -2;
	WHEN OTHERS THEN
		Retfun := -1;
   END;
   return (Retfun);
END sqlproc_VERI_template_tcp;
/


