CREATE OR REPLACE FUNCTION SQLOLHA_OVERWRITE (nome in varchar2, com_dig in int, mensalert out varchar2) 
    RETURN NUMBER IS
	Retorno NUMBER;
	status VARCHAR2(1);
	comando VARCHAR2(2);
	acaox VARCHAR2(15);
	tipo VARCHAR2(1);
	endereco VARCHAR2(15);
	reco_lock EXCEPTION;
	PRAGMA EXCEPTION_INIT (reco_lock, -54);  

BEGIN
    endereco := nome;
    Retorno := 0;
    
    IF (com_dig = 1) then
   		BEGIN
			SELECT st, cc, tipo_cc, acao into status, comando, tipo, acaox FROM cp_nb  
				WHERE end_ip = endereco and
					  st = '1' and
					  cc = '38' and
					  tipo_cc = '1'	
				 for update nowait;

			mensalert := endereco||status||comando||tipo||acaox;

			UPDATE cp_nb set st = '4' 		
				WHERE end_ip = endereco and
					  st = '1' and 
					  cc = '38' and
					  tipo_cc = '1'	;
			Retorno := 1;
			COMMIT;
						  
		EXCEPTION
			WHEN reco_lock THEN           -- reg. ja'lockado
			    Retorno := -2;
			WHEN NO_DATA_FOUND THEN
				Retorno := 0;
			WHEN OTHERS THEN
				Retorno := -1;
		END;

	ELSE
		BEGIN
			SELECT st, cc, tipo_cc, acao into status, comando, tipo, acaox FROM cp_nb 
				WHERE end_ip = endereco and
						  st = '1' and
					  tipo_cc = '0'	and 
						  cc = '24';
						  
			mensalert := endereco||status||comando||tipo||acaox;
			Retorno := 2;
		
		EXCEPTION
			WHEN NO_DATA_FOUND THEN
				Retorno := 0;
			WHEN OTHERS THEN
				Retorno := -1;
		END;
	END IF;

    return (Retorno);

END SQLOLHA_OVERWRITE;
/