CREATE OR REPLACE FUNCTION SQLOLHA_ALARME_TCP (nome in varchar2, mensalert out varchar2) 
    RETURN NUMBER IS
	Retorno NUMBER;
	status VARCHAR2(1);
	comando VARCHAR2(2);
	acaox VARCHAR2(15);
	tipo VARCHAR2(1);
	endereco VARCHAR2(15);
	reco_lock EXCEPTION;
	PRAGMA EXCEPTION_INIT (reco_lock, -54);  

BEGIN
    endereco := nome;
    Retorno := 0;
    BEGIN
	SELECT st, cc, tipo_cc, acao into status, comando, tipo, acaox FROM cp_nb 
        WHERE end_ip = endereco and
	      st = '1' and
	      tipo_cc = '0'
	for update nowait;

	mensalert := endereco||status||comando||tipo||acaox;

	UPDATE cp_nb set st = '4' WHERE end_ip = endereco and
	      st = '1' and
	      tipo_cc = '0';

	COMMIT;

    EXCEPTION
        WHEN reco_lock THEN           -- reg. ja'lockado
	    Retorno := 1;
	WHEN NO_DATA_FOUND THEN
	    Retorno := 1;
	WHEN OTHERS THEN
      	    Retorno := -1;
    END;
    return (Retorno);

END sqlolha_alarme_tcp;
/