CREATE or REPLACE FUNCTION sqlatu_geral2(cEndIp in VARCHAR2, 
pt_aviso in VARCHAR2,
cTipo in VARCHAR2,
cData in VARCHAR2)
RETURN NUMBER IS

cStatus VARCHAR2(1);
cAviso VARCHAR2(2);
cMens  VARCHAR2(30);
cAux   VARCHAR2(1);
dData  DATE;

reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);
nRet1 number;
nRet2 number;
nRet3 number;
nRet4 number;

begin
	nRet1 := 0;
	-- atualiza PEND_ON002
	nRet1 := 0;
	begin
		select /*+ INDEX (INDEX1_PEND_ON002) */
			STATUS into cAux from PEND_ON002
		where END_IP = cEndIp for update nowait;

		update /*+ INDEX (INDEX1_PEND_ON002) */
			PEND_ON002 
		set	STATUS = '6', 
		    QTD_LIVRE = 0,
		    STATUS_OFF = '6',
		    QTD_LIVREOFF = 0
		where END_IP = cEndIp;
	exception
		when reco_lock then nRet1 := -1;
		when NO_DATA_FOUND then nRet1 := 0;
		when others then nRet1 := -1;
	end;


	-- ATUALIZA CP_BN
	nRet2 := 0;
	cAviso := SUBSTR(pt_aviso, 16,2);
	cStatus:= SUBSTR(pt_aviso, 18,1);
	cMens  := SUBSTR(pt_aviso, 19,30);

	BEGIN
		select /*+ INDEX (INDEX2_CPBN) */
			ST into cAux 
			from CP_BN 
			where AVISO = cAviso and
              	  END_IP = cEndIp
			for update nowait; 

	EXCEPTION
		WHEN reco_lock then nRet2 := -1;
      	WHEN NO_DATA_FOUND then nRet2 := 1;
	END;

	if (nRet2 = 0) then            -- aviso existe, substitui aviso 
		update /*+ INDEX (INDEX2_CPBN) */
		CP_BN set ST = cStatus, 
				EPN3 = cMens 
		where AVISO = cAviso AND
              END_IP = cEndIp;

	elsif (nRet2 = 1) then       
		-- aviso nao existe, sera' inserido novo comando
		insert into CP_BN (END_IP, AVISO, ST, EPN3) 
			values (cEndIp, cAviso, cStatus, cMens);          
	end if;


	-- ATUALIZA DAT07
	nRet3 := 0;
	dData := to_date (cData, 'ddmmyyhh24miss');
	BEGIN
		select /*+ INDEX (INDEX2_DAT07) */
			ATUFORC into cAux from DAT07 
		where END_IP = cEndIp
			for update nowait;
		
		update /*+ INDEX (INDEX2_DAT07) */ DAT07 
			set ATUFORC = cTipo,
				DATFORC = dData
		where END_IP = cEndIp;
		
	EXCEPTION
		WHEN NO_DATA_FOUND then nRet3 := -1;
		WHEN OTHERS then nRet3 := -1;
	end;

	-- ATUALIZA DIG002
	nRet4 := 0;
	BEGIN
		select /*+ INDEX (INDEX1_DIG002) */
			STATUS into cAux from DIG002 
		where END_IP = cEndIp
			for update nowait;
		
		update /*+ INDEX (INDEX1_DIG002) */ DIG002
			set STATUS = '6'
		where END_IP = cEndIp;
		
	EXCEPTION
		WHEN NO_DATA_FOUND then nRet4 := 0;
		WHEN OTHERS then nRet4 := -1;
	end;

	COMMIT;

	if ((nRet1 = -1) or (nRet2 = -1) or (nRet3 = -1) or (nRet4 = -1)) then
		return (-1);
	else
		return (0);
	end if;

END sqlatu_geral2;
/
