CREATE OR REPLACE FUNCTION sqlver_matvei2(cMatric VARCHAR2, cVeiculo VARCHAR2, cDataVeic OUT VARCHAR2, cBloq OUT VARCHAR2)
   RETURN NUMBER IS
      Ret NUMBER;
      Termina BOOLEAN := True;
      cMatTodas VARCHAR2(15);

      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado
BEGIN
   Ret := 1;
   cMatTodas := '000000000000';
   BEGIN
   SELECT DataHora, Situa INTO cDataVeic, cBloq
      FROM CONTVEI
      WHERE ICard = cMatTodas AND
	    ICardV = cVeiculo ;

   EXCEPTION
      WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
         Termina := false;
      WHEN OTHERS THEN              -- outros erros
          Ret := -1;
   END;

    if (Termina)  THEN
      return (Ret);
    end if;

   BEGIN
   SELECT DataHora, Situa INTO cDataVeic, cBloq
      FROM CONTVEI
      WHERE ICard = cMatric AND
	    ICardV = cVeiculo;

   EXCEPTION
      WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
         Ret := 0;
      WHEN OTHERS THEN              -- outros erros
         Ret := -1;
   END;

   return (Ret);
END sqlver_matvei2;
/

