CREATE OR REPLACE FUNCTION sqlver_matcodin_tcp (cMatric varchar2, cEndIp varchar2, cDiaSem varchar2, cFaixa in out varchar2, cLaces in out varchar2)
   RETURN NUMBER IS
   Ret    NUMBER;
   Ret1   NUMBER;
   cDia_1 VARCHAR(1);
   cDia_2 VARCHAR(1);
   nDia   NUMBER;

BEGIN
	Ret := 1;
    cLaces := '000';
    --nDia := to_number(cDiaSem);
   
    cDia_1 := substr (cDiaSem, 1,1);
    cDia_2 := substr (cDiaSem, 2,1);

    -- verifica a qual laces pertence o codin
    BEGIN
		SELECT LACES INTO cLaces FROM DAT07 
	    WHERE END_IP = cEndIp;
    EXCEPTION
		WHEN NO_DATA_FOUND then 
			cLaces := '000';
		WHEN OTHERS then
		    Ret := -1;
    END;
    
    IF (Ret = -1) then
		return (Ret);
    END IF;
	
    -- verifica tabela MATCODIN (MATRICULA X CODIN), procurando pelo feriado ou dia da semana
    BEGIN
		SELECT FxPerm INTO cFaixa
		FROM MATCODIN
		WHERE Icard = cMatric AND
		      End_Ip = cEndIp AND
		      DiaSem = cDia_1;
		Ret := 1;
    EXCEPTION
		WHEN NO_DATA_FOUND then 
			Ret := 0;
		WHEN OTHERS then 
			Ret := -1;
    END;


    -- verifica se a primeira busca epor feriado e no encontrou, continua busca pelo dia da semana
    IF (Ret = 0 AND cDia_1 = '8')  THEN
		BEGIN
			SELECT FxPerm INTO cFaixa
			FROM MATCODIN
			WHERE Icard = cMatric AND
				End_Ip = cEndIp AND
				DiaSem = cDia_2;
			Ret := 1;
		EXCEPTION
			WHEN NO_DATA_FOUND then Ret := 0;
			WHEN OTHERS then Ret := -1;
		END;
	END IF;
	
    IF (Ret = 0 AND cDia_2 > '1' AND cDia_2 < '7')  THEN
		BEGIN
			Ret1 := 1;
			SELECT FxPerm INTO cFaixa
			FROM MATCODIN
			WHERE Icard = cMatric AND
				  End_Ip = cEndIp AND
				  DiaSem = '0';
		EXCEPTION
			WHEN NO_DATA_FOUND THEN Ret1 := 0;
			WHEN OTHERS THEN Ret1 := -1;
		END;
		return (Ret1);
    ELSE
		return (Ret);
    END IF;

END sqlver_matcodin_tcp;
/

