CREATE or REPLACE FUNCTION sqller_pendon005
(
cEndIp in VARCHAR2,
cListaNS in out VARCHAR2,
cListaId in out VARCHAR2, 
cListaAtu in out VARCHAR2
) 
RETURN NUMBER IS

xCont NUMBER;
xNSerial CHAR(10);
xIdent CHAR(14);
xAtu CHAR(1);
cStatus CHAR(1);
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);


begin
    xCont := 0;
	begin
	   select /*+ INDEX (INDEX1_PEND_ON002) */
	   		STATUS_LPZ into cStatus
			from PEND_ON002LPZ 
			where END_IP = cEndIp for update nowait;
		if (cStatus = '1') then
			cListaNS := '0000000001' || ';';
			cListaId := '01010101010101' || ';';
			cListaAtu := '1' || ';';
			begin
				xCont := 1;
				update /*+ INDEX (INDEX1_PEND_ON002LPZ) */
					PEND_ON002LPZ set STATUS_LPZ = '2' where END_IP = cEndIp;
			end;
		end if;
		COMMIT;
    exception
		when NO_DATA_FOUND then xCont := 0;
		when reco_lock then xCont := -1;		
		when others then xCont := -2;
    end;
	return (xCont);
END sqller_pendon005;
/

