CREATE or REPLACE FUNCTION sqller_pendon004
(
cEndIp in VARCHAR2,
cListaNS in out VARCHAR2,
cListaId in out VARCHAR2, 
cListaCpo in out VARCHAR2,
cListaInfo in out VARCHAR2
) 
RETURN NUMBER IS

xCont NUMBER;
xNSerial CHAR(10);
xIdent CHAR(14);
xCpo CHAR(2);
xInfo CHAR(10);
cStatus CHAR(1);
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);

cursor cursor_lpendOff is
	select /*+ INDEX (INDEX1_PEND_ON004) */
		NUMSERIAL, IDENTIF , NUMCPO, INFORM
		from PEND_ON004 
		where END_IP = cEndIp
		order by NUMSERIAL, to_number(NUMCPO);    


begin
    xCont := 0;
	begin
	   select /*+ INDEX (INDEX1_PEND_ON002OFF) */
	   		STATUS_OFF into cStatus
			from PEND_ON002OFF 
			where END_IP = cEndIp;
		if (cStatus = '1') then
			OPEN cursor_lpendOff;
			LOOP
				fetch cursor_lpendOff INTO xNSerial, xIdent, xCpo, xInfo;
				EXIT when cursor_lpendOff%NOTFOUND;

				cListaNS := cListaNS || xNSerial;
				cListaId := cListaId || ret_identif(xIdent);
				cListaCpo := cListaCpo || xCpo || ';';
				cListaInfo := cListaInfo || xInfo ||';';
				
				xCont := xCont+1;
				if (xCont = 60) then
					Exit;
				end if;
			END LOOP;
			CLOSE cursor_lpendOff;
			cListaNS := cListaNS || ';';
			cListaId := cListaId || ';';
			cListaCpo := cListaCpo || ';';
			cListaInfo := cListaInfo || ';';
			begin
				select /*+ INDEX (INDEX1_PEND_ON002OFF) */
					STATUS_OFF into cStatus 
					from PEND_ON002OFF 
					where END_IP = cEndIp for update nowait;
				if (xCont = 0) then
					-- indica em PEND_ON002 que a lista foi carregada 
					update /*+ INDEX (INDEX1_PEND_ON002OFF) */
						PEND_ON002OFF set STATUS_OFF = '3' where END_IP = cEndIp;
				else
					update /*+ INDEX (INDEX1_PEND_ON002OFF) */
						PEND_ON002OFF set STATUS_OFF = '2' where END_IP = cEndIp;
				end if;
				COMMIT;
			exception
				when NO_DATA_FOUND then xCont := 0;
				when reco_lock then xCont := -1;
				when others then xCont := -2;
			end;
		end if;
    exception
		when NO_DATA_FOUND then xCont := 0;
		when others then xCont := -2;
    end;
	return (xCont);
END sqller_pendon004;
/

