CREATE or REPLACE FUNCTION sqller_pendon003(cEndIp in VARCHAR2,cListaNS in out VARCHAR2,cListaId in out VARCHAR2, cHorExp in out VARCHAR2) 
RETURN NUMBER IS

xCont NUMBER;
xNSerial CHAR(10);
xIdent CHAR(14);
cStOn002 CHAR(1);
nHoras number;
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);

cursor cursor_lpend is
	select /*+ INDEX (INDEX1_PEND_ON003) */
		NUMSERIAL, IDENTIF 
		from PEND_ON003 
		where END_IP = cEndIp
		order by NUMSERIAL;    


begin
    xCont := 0;
	begin
	   select /*+ INDEX (INDEX1_PEND_ON002ON) */
	   		STATUS, QHOR_EXP into cStOn002, nHoras 
			from PEND_ON002ON 
			where END_IP = cEndIp;

		if (cStOn002 = '1') then
			OPEN cursor_lpend;
			LOOP
				fetch cursor_lpend INTO xNSerial, xIdent;
				EXIT when cursor_lpend%NOTFOUND;

				cListaNS := cListaNS || xNSerial;
				cListaId := cListaId || ret_identif(xIdent);
				xCont := xCont+1;
				if (xCont = 85) then
					Exit;
				end if;
			END LOOP;
			cListaNS := cListaNS || ';';
			cListaId := cListaId || ';';
			cHorExp := substr(to_char(nHoras),1,2);
			CLOSE cursor_lpend;

			begin
				select /*+ INDEX (INDEX1_PEND_ON002ON) */
					STATUS, QHOR_EXP into cStOn002, nHoras 
					from PEND_ON002ON 
					where END_IP = cEndIp for update nowait;
				if (xCont = 0) then
					-- indica em PEND_ON002 que a lista foi carregada 
					update /*+ INDEX (INDEX1_PEND_ON002ON) */
						PEND_ON002ON set STATUS = '3' where END_IP = cEndIp;
				else
					update /*+ INDEX (INDEX1_PEND_ON002ON) */
						PEND_ON002ON set STATUS = '2' where END_IP = cEndIp;
				end if;
				COMMIT;
			exception
				when NO_DATA_FOUND then xCont := 0;
				when reco_lock then xCont := -1;
				when others then xCont := -2;
			end;
		end if;
    exception
		when NO_DATA_FOUND then xCont := 0;
		when others then xCont := -2;
    end;
	return (xCont);
END sqller_pendon003;
/

