CREATE OR REPLACE FUNCTION sqlcon_lista_negra (cMatric VARCHAR2, mensagem OUT VARCHAR2) 
   RETURN NUMBER IS
      RetFun NUMBER;
      VarAux   VARCHAR2(12);
      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado 
BEGIN
   RetFun := 0;       -- assume matricula encontrada
   BEGIN
   SELECT ICard into VarAux FROM DAT09 
      WHERE ICard = cMatric;
   mensagem := 'ok';
   
   EXCEPTION
      WHEN reco_lock THEN
         RetFun := -1;              -- reg. lockado
         mensagem := 'Matriccula '|| cMatric ||' lockada!! Retorno = '|| TO_CHAR (RetFun);
      WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
         RetFun := -2;
         mensagem := 'Matricula ' || cMatric || ' nao encontrado !! Retorno = '|| TO_CHAR(RetFun);
      WHEN OTHERS THEN              -- outros erros
         RetFun := -1;
         mensagem := 'Outros erros encontrados!! Retorno = '|| TO_CHAR(RetFun);
   END;
   return (RetFun);
END sqlcon_lista_negra;
/

