-- insere em PEND_ON007 as atualizaes realizadas no codin via atualizacao forcada ou em lista
-- atualiza em PEND_ON002 a qtde.livre resultante no codin

CREATE or REPLACE FUNCTION sqlins_pendon007 (
	cAtualizado in VARCHAR2,
	cNSerial in VARCHAR2,
	cEndIp in VARCHAR2, 
	nLivre in NUMBER,
	nLivreOff in NUMBER,
	cDatacod in VARCHAR2,
	cDataFim in VARCHAR2,
	cEvento in VARCHAR2
) RETURN NUMBER IS

Xidentif CHAR(14);
Xnumserial char(10);
Xicard char(12);
Xnumcpo char(2);
Xinform char(56);
reco_locK EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);
nRet number;
nAux number;

	
BEGIN
	nRet := 0;
	IF (cAtualizado = '1') THEN -- cartao atualizado
		BEGIN
			SELECT /*+ INDEX (INDEX2_ATUALI) */
				icard, numcpo, inform 
			into Xicard, Xnumcpo, Xinform 
			FROM ATUALI 
			WHERE NUMSERIAL = cNSerial  and IDENTIF = to_identif (cDataFim);
	
			INSERT into PEND_ON007 (IDENTIF, EVENTO,NUMSERIAL, ICARD, NUMCPO, INFORM, END_IP, INCLUSAO)
					    values  (to_identif(cDataFim), cEvento, cNSerial, Xicard, Xnumcpo, Xinform, cEndIP, SYSDATE);

		
		EXCEPTION
			WHEN NO_DATA_FOUND THEN
				nAux := 0;
			WHEN others THEN 
				nRet := -1;
		END;

		BEGIN
			-- atualiza qtde.livre no codin
			SELECT /*+ INDEX (INDEX1_PEND_ON002ON) */ 
				QTD_LIVRE into nAux 
			FROM PEND_ON002ON 
			WHERE END_IP = cEndIP for update nowait;
		    
		    UPDATE /*+ INDEX (INDEX1_PEND_ON002ON) */ 
		    	PEND_ON002ON set QTD_LIVRE = nLivre 
	    	WHERE END_IP = cEndIP;

		EXCEPTION
		   WHEN reco_lock THEN nRet := 0;
		   WHEN others THEN nRet := -1;
		END;

				
		BEGIN
			-- atualiza qtde.livre no codin
			SELECT /*+ INDEX (INDEX1_PEND_ON002OFF) */ 
				QTD_LIVREOFF into nAux 
			FROM PEND_ON002OFF 
			WHERE END_IP = cEndIP for update nowait;
		    
		    UPDATE /*+ INDEX (INDEX1_PEND_ON002) */ 
		    	PEND_ON002OFF set QTD_LIVREOFF = nLivreOff
	    	WHERE END_IP = cEndIP;

		EXCEPTION
		   WHEN reco_lock THEN nRet := 0;
		   WHEN others THEN nRet := -1;
		END;
		
		COMMIT;
	END IF;
	return (nRet);
	
END sqlins_pendon007;
/
