-- INICIO1TCPARL.SQL : Criacao de Tablespace e usuario principal

-- conectar como Sys
SPOOL C:\ACESSO\SCRIPTS\RESULT1.LOG;
CONNECT SYS/CHANGE_ON_INSTALL as sysdba;

-- criar tablespaces 
CREATE TABLESPACE ACESDATA DATAFILE 'C:\ACESSO\DATABASE\ACESDAT1.ORA' SIZE 500M;
CREATE TABLESPACE ACESINDX DATAFILE 'C:\ACESSO\DATABASE\ACESIND1.ORA' SIZE 200M;
-- TABLESPACE TEMPORARIO PARA ORACLE 9I E ANTERIORES
CREATE TEMPORARY TABLESPACE ACESTMP TEMPFILE 'C:\ACESSO\dATABASE\ACESTMP1.ORA' SIZE 20M;

-- Criar usuario Telemat com senha telemat
CREATE USER TELEMAT IDENTIFIED BY TELEMAT DEFAULT TABLESPACE ACESDATA TEMPORARY TABLESPACE ACESTMP;

-- Atribuir privilegios ao usuario Telemat
GRANT RESOURCE TO TELEMAT;
GRANT CONNECT TO TELEMAT;
GRANT UNLIMITED TABLESPACE TO TELEMAT;
GRANT QUERY REWRITE TO TELEMAT;
GRANT CREATE USER TO TELEMAT;
GRANT CREATE ROLE TO TELEMAT;
GRANT CREATE VIEW TO TELEMAT;
GRANT CREATE SYNONYM TO TELEMAT WITH ADMIN OPTION;
GRANT CREATE SESSION TO TELEMAT WITH ADMIN OPTION;

GRANT EXECUTE ON DBMS_SQL TO TELEMAT;
GRANT EXECUTE ON DBMS_SYS_SQL TO TELEMAT;
GRANT EXECUTE ON DBMS_LOCK TO TELEMAT;
GRANT EXECUTE ON DBMS_ALERT TO TELEMAT;
GRANT SELECT ON V_$MYSTAT TO TELEMAT;
GRANT SELECT ON V_$LOCK TO TELEMAT WITH GRANT OPTION;
GRANT EXECUTE ON DBMS_JOB TO TELEMAT;


-- Criacao de Profile
DROP PROFILE PROF_ACESSO;
CREATE PROFILE PROF_ACESSO LIMIT IDLE_TIME 3;

DROP ROLE EXECFUNTCP;
DROP ROLE EXECFUNARL;
DROP ROLE EXECFUNPRI;

SPOOL OFF;

-- continue com INICIO2.SQL: Criacao de tabelas de Controle de Acesso
