CREATE or REPLACE FUNCTION sqller_atupendon2(cDataCod in VARCHAR2,cNSerial in VARCHAR2,cEndIp in VARCHAR2,
cDataMor in out VARCHAR2,cRegCampo in out VARCHAR2,cRegValor in out VARCHAR2, cRegIdent in out VARCHAR2) 
RETURN NUMBER IS

XCONT NUMBER;
XIDMAIOR CHAR(14);

TYPE identif_type IS TABLE OF ATUALI.identif%TYPE 
	INDEX BY binary_integer;
TYPE numcpo_type IS TABLE OF ATUALI.numcpo%TYPE 
	INDEX BY binary_integer;
TYPE inform_type IS TABLE OF ATUALI.inform%TYPE 
	INDEX BY binary_integer;
	
l_identif identif_type;
l_numcpo numcpo_type;
l_inform inform_type;

begin
	
	cRegCampo := Null;
	cRegValor := Null;
	cRegIdent := Null;
	
	SELECT distinct identif, numcpo, inform 
		BULK COLLECT INTO l_identif, l_numcpo, l_inform 
	from 
		ATUALI 
	WHERE NUMSERIAL = cNSerial  and 
	      IDENTIF > to_identif (cDatacod) and
	      IDENTIF in (SELECT MAX(IDENTIF) 
					FROM ATUALI WHERE NUMSERIAL = cNSerial 
					GROUP BY to_number(NUMCPO))
	order by to_number(NUMCPO);

	XIDMAIOR := '01010100000000';
	XCONT := l_identif.count;
	FOR indx IN 1 .. XCONT 
	LOOP
		cRegCampo := cRegCampo || l_numcpo(indx) || '[';
		cRegValor := cRegValor || l_inform(indx) || '[';
		cRegIdent := cRegIdent || ret_identif(l_identif(indx)) || '[';
		
		if (l_identif(indx) > XIDMAIOR) THEN
			XIDMAIOR := l_identif(indx);
		end if;
	END LOOP;
		
	cRegCampo := cRegCampo || ';';
	cRegValor := cRegValor || ';';
	cRegIdent := cRegIdent || ';';

	cDataMor := ret_identif(XIDMAIOR); 	-- cDataMor := ddmmyyhhmissxx 
	IF (XCONT = 0) THEN
		RETURN (0);
	ELSE
		RETURN (1);
	END IF;
END sqller_atupendon2;
/

