CREATE OR REPLACE FUNCTION sqlfuso_horario_tcp2 (cEndIp varchar2, cData in out varchar2) 
   RETURN NUMBER IS
   Ret    NUMBER;
   cFuso varchar2(8);
   Minutos NUMBER;

BEGIN
    Ret := 1;
    cFuso := '0000';
    BEGIN
    	SELECT Fuso INTO cFuso
		FROM DAT07
		WHERE End_Ip = cEndIp;
    EXCEPTION
		WHEN NO_DATA_FOUND then Ret := 0;
		WHEN OTHERS then Ret := -1;
    END;

    IF (Ret >= 0) THEN
		Minutos := to_number(cFuso);
   		SELECT TO_CHAR (sysdate+(Minutos/1440), 'DD/MM/YYYY HH24:MI:SS') || '0' || TO_CHAR (sysdate, 'D')
      	    INTO cData FROM dual;
    END IF;
    return (Ret);

END sqlfuso_horario_tcp2;
/

