CREATE or REPLACE FUNCTION sqlins_credlog(
cMatric in VARCHAR2, cData in VARCHAR2, nTipo in NUMBER) 
RETURN NUMBER IS

    nCont NUMBER;
    nMaximo NUMBER;
    cMatAux VARCHAR2(12);
    cAnoAux VARCHAR2(4);
    cMesAux VARCHAR2(2);
    cDiaAux VARCHAR2(2);
    cHoraAux VARCHAR2(4);
    cSegAux VARCHAR2(2);
    cTipoAux VARCHAR2(1);

    cAnoReg VARCHAR2(4);
    cMesReg VARCHAR2(2);
    cDiaReg VARCHAR2(2);
    cHoraReg VARCHAR2(4);
    cSegReg VARCHAR2(2);

    CURSOR CURSOR_ULTCRED IS
	SELECT ICARD, ANO, MES, DIA, HORA, SEGUNDO, TIPO 
            FROM  CREDLOG
            WHERE ICARD = cMatric and
                  TIPO = TO_CHAR(nTipo)
            ORDER BY (ANO||MES||DIA||HORA||SEGUNDO);

BEGIN
    cAnoReg := substr(cData, 1, 4);
    cMesReg := substr(cData, 5, 2); 
    cDiaReg := substr(cData, 7, 2);
    cHoraReg :=	substr(cData, 9, 4);
    cSegReg := substr(cData, 13, 2);

    -- verifica se ja existe a marcacao
    BEGIN
    SELECT ICARD INTO cMatAux FROM CREDLOG
	WHERE ANO||MES||DIA||HORA||SEGUNDO = cData AND
	      ICARD = cMatric AND
	      TIPO = TO_CHAR(nTipo);
    RETURN (1);		-- retorna marcacao ja realizada

    EXCEPTION
	WHEN NO_DATA_FOUND THEN          -- reg. nao encontrado
	    BEGIN
	    -- verifica quantas marcacoes existem para o tipo de credito
	    SELECT COUNT(*) INTO nCont FROM CREDLOG
                WHERE ICARD = cMatric AND
		      TIPO = nTipo;
	    IF (nTipo = 0) THEN		-- 0 = marcacao de refeitorio
		nMaximo := 20;
	    ELSE			-- 1 = marcacao de beneficio
		nMaximo := 5;
	    END IF;
	    -- verifica se qtde de marcacoes atingiu o maximo de registros em tabela
	    IF (nCont >= nMaximo) THEN
		OPEN CURSOR_ULTCRED;
	        LOOP
		FETCH CURSOR_ULTCRED INTO cMatAux, cAnoAux, cMesAux, cDiaAux,
					  cHoraAux, cSegAux, cTipoAux;
		EXIT;
		END LOOP;
		CLOSE CURSOR_ULTCRED;

		-- atualiza a marcacao mais antiga com esta ultima marcacao
		UPDATE CREDLOG SET ANO = cAnoReg, MES = cMesReg, DIA = cDiaReg,
				   HORA = cHoraReg, SEGUNDO = cSegReg
		    WHERE ANO = cAnoAux AND
			  MES = cMesAux AND 
			  DIA = cDiaAux AND
			  HORA = cHoraAux AND
			  SEGUNDO = cSegAux AND
			  ICARD = cMatric AND
			  TIPO = TO_CHAR(nTipo);
	    ELSE
		-- nao atingiu o maximo, insere este novo registro
	        INSERT INTO CREDLOG (ICARD, TIPO, ANO, MES, DIA, HORA, SEGUNDO)
		     VALUES (cMatric, to_char(nTipo),
			     cAnoReg, cMesReg, cDiaReg, cHoraReg, cSegReg);			     
	    END IF;
	    COMMIT;
	    RETURN (0);		-- retorna marcacao nao existente	   

	    EXCEPTION
		WHEN NO_DATA_FOUND THEN
	            INSERT INTO CREDLOG (ICARD, TIPO, ANO, MES, DIA, HORA, SEGUNDO)
			    VALUES (cMatric, to_char(nTipo), 
			            cAnoReg, cMesReg, cDiaReg, cHoraReg, cSegReg);			     
		    COMMIT;
		    RETURN (0);
	
		WHEN OTHERS THEN
		    RETURN (-1);
	    END;    	    
    END;
END sqlins_credlog;
/ 


