CREATE OR REPLACE FUNCTION sqlcons_contplanta (cMatric VARCHAR2, cPlanta VARCHAR2, cDataHorVal OUT VARCHAR2)
   RETURN NUMBER IS
      Ret NUMBER;
      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado 
BEGIN
   Ret := 1;
   BEGIN
   SELECT DataHora INTO cDataHorVal
      FROM CONTPLANTA
      WHERE ICard = cMatric AND
	    Plantacesso = cPlanta;

   EXCEPTION
      WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
         Ret := 0;
      WHEN OTHERS THEN              -- outros erros
         Ret := -1;
   END;

   return (Ret);
END sqlcons_contplanta;
/

