CREATE OR REPLACE FUNCTION sqlcon_coacao_tsi1 (cMatric VARCHAR2,
cTempl_Coa1tot IN OUT VARCHAR2, cTempl_Coa2tot IN OUT VARCHAR2, 
cTempl_Coa3tot IN OUT VARCHAR2, cTempl_Coa4tot IN OUT VARCHAR2,
cTempl_Coa5tot IN OUT VARCHAR2
) 
RETURN NUMBER IS
RetFun	NUMBER;
Coa 	NUMBER;
cTempl_Coa5Aux VARCHAR2(128);
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado

BEGIN
	RetFun := 1;
	Coa := 1;
	BEGIN
		SELECT 
			Templ_Coa1, Templ_Coa2, Templ_Coa3, Templ_Coa4, Templ_Coa5
		INTO 
			cTempl_Coa1tot, cTempl_Coa2tot, cTempl_Coa3tot, cTempl_Coa4tot, cTempl_Coa5Aux 
		FROM CONTDIG_TSI1 
		WHERE Icard = cMatric;
		if ((cTempl_Coa1tot is Null) or (cTempl_Coa2tot is Null) or
			(cTempl_Coa3tot is Null) or (cTempl_Coa4tot is Null) or
			(cTempl_Coa5Aux is Null) or
			(length(cTempl_Coa1tot) < 160) or (length(cTempl_Coa2tot) < 160) or
			(length(cTempl_Coa3tot) < 160) or (length(cTempl_Coa4tot) < 160) or 
			(length(cTempl_Coa5Aux) < 128)) then 
			Coa := 0;
		end if;
		if (length(cTempl_Coa5Aux) = 128) then
			cTempl_Coa5tot := RPAD(cTempl_Coa5Aux, 160, '0');
		end if;
			
	EXCEPTION
		WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
			Coa := 0;
		WHEN OTHERS THEN              -- outros erros
			RetFun := -1;
			return (RetFun);
	END;
	IF (Coa = 0) THEN
		RetFun := 0;
	end if;
	Return (RetFun);
END sqlcon_coacao_tsi1;
/
