CREATE OR REPLACE FUNCTION sqlbloq_numserial (cNumeroSerial VARCHAR2) 
   RETURN NUMBER IS
      RetFun NUMBER;
      VarAux   VARCHAR2(10);
      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado 
      
BEGIN

	RetFun := 1;       -- assume numero serial encontrado
	BEGIN
		SELECT NumSerial into VarAux FROM DAT05 
			WHERE NumSerial = cNumeroSerial;
			
	EXCEPTION
		WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
			RetFun := 0;
		WHEN OTHERS THEN              -- outros erros
			RetFun := -1;
	END;
	return (RetFun);
	
END sqlbloq_numserial;
/

