CREATE OR REPLACE FUNCTION sqlavisa_cpbb_novell_tcp (pt_aviso in VARCHAR2)
   RETURN NUMBER IS
   nRetSem NUMBER;
   cEndIp VARCHAR2(15);
   cAviso VARCHAR2(2);
   cStat  VARCHAR2(1);
   cMens  VARCHAR2(30);
   cAux   VARCHAR2(1);
   reco_lock EXCEPTION;
   PRAGMA EXCEPTION_INIT (reco_lock,-54);  -- erro quando registro lockado 
BEGIN
   nRetSem := 1;
   cEndIp := SUBSTR(pt_aviso, 1,15);
   cAviso := SUBSTR(pt_aviso, 16,2);
   cStat  := SUBSTR(pt_aviso, 18,1);
   cMens  := SUBSTR(pt_aviso, 19,30);


   BEGIN
      SELECT St INTO cAux FROM cp_bn 
	WHERE Aviso = cAviso AND
              End_ip = cEndIp;

      SELECT St INTO cAux FROM cp_bn 
	WHERE Aviso = cAviso AND
              End_ip = cEndIp
	FOR UPDATE NOWAIT; 

   EXCEPTION
      WHEN reco_lock THEN nRetSem := -1;
      WHEN NO_DATA_FOUND THEN nRetSem := 0;
   END;

   IF (nRetSem = 1) THEN            -- aviso existe, substitui aviso 
      UPDATE cp_bn SET St = cStat, 
		     Epn3 = cMens 
	WHERE Aviso = cAviso AND
              End_ip = cEndIp;

      -- atualiza semaforo e efetiva transacao 
--      UPDATE sbbe SET sinal = '1';
--      COMMIT;        

   ELSIF (nRetSem = 0) THEN       
      -- aviso nao existe, sera' inserido novo comando
      INSERT INTO cp_bn (End_ip, aviso, st, epn3) VALUES (cEndIp, cAviso, cStat, cMens);          

      -- atualiza semaforo e efetiva transacao 
      -- UPDATE sbbe SET sinal = '1';
      -- COMMIT;     

   END IF; 
   COMMIT;     
   return (nRetSem);
END sqlavisa_cpbb_novell_tcp;
/

