CREATE OR REPLACE FUNCTION sqlatu_forcdat07 (
	cEndIp in VARCHAR2,
	cTipo in VARCHAR2,
	cData in VARCHAR2
	) return number is
dData date;
cAux char(1);

Begin

	dData := to_date (cData, 'ddmmyyhh24miss');
	begin
		select ATUFORC into cAux
		from DAT07 
		where END_IP = cEndIp
		for update nowait;
		
		update DAT07 
		set ATUFORC = cTipo,
			DATFORC = dData
		where END_IP = cEndIp;
		commit;
		
	exception
		WHEN NO_DATA_FOUND then
			return (0);
		WHEN OTHERS then
			return (-1);
	end;
	return (0);
END sqlatu_forcdat07;
/