CREATE OR REPLACE FUNCTION sqlatualiza_handkey_tcp (matric in VARCHAR2, templ1 in VARCHAR2)
   RETURN NUMBER IS
   cAuxMat VARCHAR2(15);
   nRetorno NUMBER;
   reco_lock EXCEPTION;
   PRAGMA EXCEPTION_INIT (reco_lock,-54);  -- erro quando registro lockado 

BEGIN
	nRetorno := 1;
	BEGIN
		SELECT Icard INTO cAuxMat FROM CONTDIG
		WHERE Icard = matric 
		FOR UPDATE NOWAIT;
	EXCEPTION
		WHEN reco_lock THEN nRetorno:= -1;
		WHEN NO_DATA_FOUND THEN nRetorno := 0;
		WHEN OTHERS THEN nRetorno := -1;
	END;

	IF (nRetorno = 1) THEN          -- matricula existe, substitui digital
		UPDATE ContDig
			SET Templ_Tit1 = templ1,
				Templ_Tit2 = null,
				Templ_Tit3 = null,
				Templ_Tit4 = null,
				Nivel = '1',
				Num_Dedo_Pad = '1',
				Num_Dedo_Alt = '1'
			WHERE Icard = matric;
	
	ELSIF (nRetorno = 0) THEN       
		-- matrcula nao existe, sera' inserido novo 
		INSERT INTO CONTDIG (ICARD, TEMPL_TIT1, TEMPL_TIT2, TEMPL_TIT3, TEMPL_TIT4, 
				TEMPL_ALT1, TEMPL_ALT2, TEMPL_ALT3, TEMPL_ALT4, 
				NIVEL, NUM_DEDO_PAD, NUM_DEDO_ALT) 
		VALUES (matric, templ1, null, null, null, null, null, null, null, '1', '1', '1');
	END IF;
	
	COMMIT;     
	return (nRetorno);
	
END sqlatualiza_handkey_tcp;
/

