CREATE OR REPLACE FUNCTION sqlatu_mapabio_tcp (pt_digital in VARCHAR2, Tipo in Number) 
   RETURN NUMBER is
   nSemReg NUMBER;
   nRetorno NUMBER;
   cEndIp VARCHAR2(15);
   cIcard VARCHAR2(15);
   cTipo_Templ VARCHAR2(3);
   cNivel VARCHAR2(3);
   cAux VARCHAR2(15);
   reco_lock EXCEPTION;
   PRAGMA EXCEPTION_INIT (reco_lock,-54);  -- erro quando registro lockado 
BEGIN
   nSemReg := 0;
   cIcard := SUBSTR(pt_digital, 1, 12);
   cEndIp := SUBSTR(pt_digital,13,15);
   cTipo_Templ := SUBSTR(pt_digital, 28,1);
   cNivel := SUBSTR(pt_digital, 29,1);
   IF (Tipo = 2) THEN   -- excluir todos templates
	DELETE FROM Mapabio WHERE End_Ip = cEndIP;
   ELSE
	BEGIN
	   SELECT Icard INTO cAux FROM MapaBio
	       WHERE Icard = cIcard AND
        	     End_ip = cEndIp AND
		     Tipo_Templ = cTipo_Templ;
	   SELECT Icard INTO cAux FROM MapaBio
	       WHERE Icard = cIcard AND
        	     End_ip = cEndIp AND 
	     	     Tipo_Templ = cTipo_Templ FOR UPDATE NOWAIT;
	EXCEPTION
	      WHEN NO_DATA_FOUND THEN nSemReg := 1;
	      WHEN reco_lock THEN nSemReg:= -1;
	END;
	IF (nSemReg = -1) THEN
	    RETURN (nSemReg);
	END IF;
	IF (((Tipo = 1) OR (Tipo = 3)) AND (nSemReg = 1)) THEN   -- se (INCLUSAO ou ATUALIZACAO) e NAO HA registro
	    INSERT INTO MapaBio (Icard, End_IP, Tipo_Templ, Nivel) 
		         values (cIcard, cEndIp, cTipo_Templ, cNivel);
	ELSIF ((Tipo = 0) AND (nSemReg = 0)) THEN       -- se EXCLUSAO e HA registro
	    DELETE FROM MapaBio 
		WHERE Icard = cIcard AND
		      End_ip = cEndIp AND
		      Tipo_Templ = cTipo_Templ;
	ELSIF (Tipo = 3) THEN
	    UPDATE Mapabio SET Nivel = cNivel 
		WHERE Icard = cIcard AND
        	      End_ip = cEndIp AND
		      Tipo_Templ = cTipo_Templ;
	END IF;
   END IF;
   COMMIT;     
   RETURN (1);
END sqlatu_mapabio_tcp;
/
