CREATE OR REPLACE FUNCTION sqlat_tab_datahora (cReg_dthora in VARCHAR2) 
   RETURN NUMBER IS
      NumMat VARCHAR2(12);
      VarAux VARCHAR2(12);
      IniHA DATE;
      FimHA DATE;
      IniIJ DATE;
      FimIJ DATE;
      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  
      Retorno NUMBER;
BEGIN
	Retorno := 0;      
	NumMat := substr(cReg_dthora, 1, 12);
	IniHA := TO_DATE (substr(cReg_dthora, 13, 12), 'DDMMRRHH24MISS');
	FimHA := TO_DATE (substr(cReg_dthora, 25, 12), 'DDMMRRHH24MISS');
	IniIJ := TO_DATE (substr(cReg_dthora, 37, 12), 'DDMMRRHH24MISS');
	FimIJ := TO_DATE (substr(cReg_dthora, 49, 12), 'DDMMRRHH24MISS');
	
	-- atualiza tab.DATAHORA
	BEGIN
		SELECT Icard into VarAux from DATAHORA 
			WHERE Icard = NumMat for update nowait;
   
		UPDATE DATAHORA 
			SET Ini_Halm = IniHA,
				Fim_Halm = FimHA,
				Ini_Intj = IniIJ,
				Fim_Intj = FimIJ
   	 	WHERE Icard = NumMat;
		COMMIT;
   
	EXCEPTION
		WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
			INSERT INTO DATAHORA (Icard, Ini_Halm, Fim_Halm, Ini_Intj, Fim_Intj) 
         				  values (NumMat, IniHA, FimHA, IniIJ, FimIJ);
			COMMIT;
		WHEN OTHERS THEN
			Retorno := -1;
	END;
	return (Retorno);
END sqlat_tab_datahora;
/


